package org.aspectj.weaver;

import org.aspectj.bridge.context.CompilationAndWeavingContext;

import java.io.PrintStream;
import java.io.PrintWriter;

@SuppressWarnings("serial")
public class BCException extends RuntimeException {

    Throwable thrown;

    public BCException() {
        super();
    }

    public BCException(String s) {
        super(s + "\n" + CompilationAndWeavingContext.getCurrentContext());
    }

    public BCException(String s, Throwable thrown) {
        this(s);
        this.thrown = thrown;
    }

    public void printStackTrace() {
        printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        printStackTrace(new PrintWriter(s));
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (null != thrown) {
            s.print("Caused by: ");
            s.print(thrown.getClass().getName());
            String message = thrown.getMessage();
            if (null != message) {
                s.print(": ");
                s.print(message);
            }
            s.println();
            thrown.printStackTrace(s);
        }
    }
}
