package org.aspectj.weaver;

import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.SimpleScope;

public class BindingScope extends SimpleScope {

    private final ResolvedType enclosingType;

    private final ISourceContext sourceContext;

    private boolean importsUpdated = false;

    public BindingScope(ResolvedType type, ISourceContext sourceContext, FormalBinding[] bindings) {
        super(type.getWorld(), bindings);
        this.enclosingType = type;
        this.sourceContext = sourceContext;
    }

    public ResolvedType getEnclosingType() {
        return enclosingType;
    }

    public ISourceLocation makeSourceLocation(IHasPosition location) {
        return sourceContext.makeSourceLocation(location);
    }

    public UnresolvedType lookupType(String name, IHasPosition location) {
        if (enclosingType != null && !importsUpdated) {
            String pkgName = enclosingType.getPackageName();
            if (pkgName != null && !pkgName.equals("")) {
                String[] existingImports = getImportedPrefixes();
                String pkgNameWithDot = pkgName.concat(".");
                boolean found = false;
                for (String existingImport : existingImports) {
                    if (existingImport.equals(pkgNameWithDot)) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    String[] newImports = new String[existingImports.length + 1];
                    System.arraycopy(existingImports, 0, newImports, 0, existingImports.length);
                    newImports[existingImports.length] = pkgNameWithDot;
                    setImportedPrefixes(newImports);
                }
            }
            importsUpdated = true;
        }
        return super.lookupType(name, location);
    }
}
