package org.aspectj.weaver;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CompressingDataOutputStream extends DataOutputStream {

    private ConstantPoolWriter constantPoolWriter;

    public boolean compressionEnabled = true;

    public CompressingDataOutputStream(ByteArrayOutputStream baos, ConstantPoolWriter constantPoolWriter) {
        super(baos);
        this.constantPoolWriter = constantPoolWriter;
    }

    public CompressingDataOutputStream(FileOutputStream fos) {
        super(fos);
    }

    public boolean canCompress() {
        return constantPoolWriter != null && compressionEnabled;
    }

    public int compressSignature(String signature) {
        if (constantPoolWriter == null) {
            throw new IllegalStateException();
        }
        return constantPoolWriter.writeUtf8(signature);
    }

    public int compressFilepath(String filepath) {
        if (constantPoolWriter == null) {
            throw new IllegalStateException();
        }
        return constantPoolWriter.writeUtf8(filepath);
    }

    public int compressName(String name) {
        if (constantPoolWriter == null) {
            throw new IllegalStateException();
        }
        return constantPoolWriter.writeUtf8(name);
    }

    public void writeCompressedName(String name) throws IOException {
        writeShort(compressName(name));
    }

    public void writeCompressedSignature(String signature) throws IOException {
        writeShort(compressSignature(signature));
    }

    public void writeCompressedPath(String path) throws IOException {
        writeShort(compressFilepath(path));
    }
}
