package org.aspectj.weaver;

import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.PartialOrder;

import java.util.Map;

public abstract class ConcreteTypeMunger implements PartialOrder.PartialComparable {

    protected ResolvedTypeMunger munger;

    protected ResolvedType aspectType;

    public ConcreteTypeMunger(ResolvedTypeMunger munger, ResolvedType aspectType) {
        this.munger = munger;
        this.aspectType = aspectType;
    }

    public boolean equivalentTo(Object other) {
        if (!(other instanceof ConcreteTypeMunger)) {
            return false;
        }
        ConcreteTypeMunger o = (ConcreteTypeMunger) other;
        ResolvedTypeMunger otherTypeMunger = o.getMunger();
        ResolvedTypeMunger thisTypeMunger = getMunger();
        if (thisTypeMunger instanceof NewConstructorTypeMunger && otherTypeMunger instanceof NewConstructorTypeMunger) {
            return (((NewConstructorTypeMunger) otherTypeMunger).equivalentTo(thisTypeMunger)) && ((o.getAspectType() == null) ? (getAspectType() == null) : o.getAspectType().equals(getAspectType()));
        } else {
            return ((otherTypeMunger == null) ? (thisTypeMunger == null) : otherTypeMunger.equals(thisTypeMunger)) && ((o.getAspectType() == null) ? (getAspectType() == null) : o.getAspectType().equals(getAspectType()));
        }
    }

    public ResolvedTypeMunger getMunger() {
        return munger;
    }

    public ResolvedType getAspectType() {
        return aspectType;
    }

    public ResolvedMember getSignature() {
        return munger.getSignature();
    }

    public World getWorld() {
        return aspectType.getWorld();
    }

    public ISourceLocation getSourceLocation() {
        if (munger == null) {
            return null;
        }
        return munger.getSourceLocation();
    }

    public boolean matches(ResolvedType onType) {
        if (munger == null) {
            throw new RuntimeException("huh: " + this);
        }
        return munger.matches(onType, aspectType);
    }

    public ResolvedMember getMatchingSyntheticMember(Member member) {
        return munger.getMatchingSyntheticMember(member, aspectType);
    }

    public int compareTo(Object other) {
        ConcreteTypeMunger o = (ConcreteTypeMunger) other;
        ResolvedType otherAspect = o.aspectType;
        if (aspectType.equals(otherAspect)) {
            return getSignature().getStart() < o.getSignature().getStart() ? -1 : +1;
        } else if (aspectType.isAssignableFrom(o.aspectType)) {
            return +1;
        } else if (o.aspectType.isAssignableFrom(aspectType)) {
            return -1;
        } else {
            return 0;
        }
    }

    public int fallbackCompareTo(Object other) {
        return 0;
    }

    public boolean isTargetTypeParameterized() {
        if (munger == null) {
            return false;
        }
        return munger.sharesTypeVariablesWithGenericType();
    }

    public abstract ConcreteTypeMunger parameterizedFor(ResolvedType targetType);

    public boolean isLateMunger() {
        if (munger == null) {
            return false;
        }
        return munger.isLateMunger();
    }

    public abstract ConcreteTypeMunger parameterizeWith(Map<String, UnresolvedType> parameterizationMap, World world);

    public boolean existsToSupportShadowMunging() {
        if (munger != null) {
            return munger.existsToSupportShadowMunging();
        }
        return false;
    }

    public boolean shouldOverwrite() {
        return true;
    }
}
