package org.aspectj.weaver;

import java.util.Collection;

public interface Member extends Comparable<Member> {

    Member[] NONE = new Member[0];

    MemberKind METHOD = new MemberKind("METHOD", 1);

    MemberKind FIELD = new MemberKind("FIELD", 2);

    MemberKind CONSTRUCTOR = new MemberKind("CONSTRUCTOR", 3);

    MemberKind STATIC_INITIALIZATION = new MemberKind("STATIC_INITIALIZATION", 4);

    MemberKind POINTCUT = new MemberKind("POINTCUT", 5);

    MemberKind ADVICE = new MemberKind("ADVICE", 6);

    MemberKind HANDLER = new MemberKind("HANDLER", 7);

    MemberKind MONITORENTER = new MemberKind("MONITORENTER", 8);

    MemberKind MONITOREXIT = new MemberKind("MONITOREXIT", 9);

    AnnotationAJ[][] NO_PARAMETER_ANNOTATIONXS = new AnnotationAJ[][]{};

    ResolvedType[][] NO_PARAMETER_ANNOTATION_TYPES = new ResolvedType[][]{};

    MemberKind getKind();

    String getName();

    UnresolvedType getDeclaringType();

    UnresolvedType[] getParameterTypes();

    UnresolvedType[] getGenericParameterTypes();

    UnresolvedType getType();

    UnresolvedType getReturnType();

    UnresolvedType getGenericReturnType();

    String getSignature();

    JoinPointSignatureIterator getJoinPointSignatures(World world);

    int getArity();

    String getParameterSignature();

    int getModifiers(World world);

    int getModifiers();

    boolean canBeParameterized();

    AnnotationAJ[] getAnnotations();

    Collection<ResolvedType> getDeclaringTypes(World world);

    String[] getParameterNames(World world);

    UnresolvedType[] getExceptions(World world);

    ResolvedMember resolve(World world);

    int compareTo(Member other);
}
