package org.aspectj.weaver;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

import java.io.IOException;
import java.util.List;
import java.util.Set;

public class NewConstructorTypeMunger extends ResolvedTypeMunger {

    private ResolvedMember syntheticConstructor;

    private ResolvedMember explicitConstructor;

    public NewConstructorTypeMunger(ResolvedMember signature, ResolvedMember syntheticConstructor, ResolvedMember explicitConstructor, Set superMethodsCalled, List typeVariableAliases) {
        super(Constructor, signature);
        this.syntheticConstructor = syntheticConstructor;
        this.typeVariableAliases = typeVariableAliases;
        this.explicitConstructor = explicitConstructor;
        this.setSuperMethodsCalled(superMethodsCalled);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NewConstructorTypeMunger)) {
            return false;
        }
        NewConstructorTypeMunger o = (NewConstructorTypeMunger) other;
        return ((syntheticConstructor == null) ? (o.syntheticConstructor == null) : syntheticConstructor.equals(o.syntheticConstructor)) & ((explicitConstructor == null) ? (o.explicitConstructor == null) : explicitConstructor.equals(o.explicitConstructor));
    }

    public boolean equivalentTo(Object other) {
        if (!(other instanceof NewConstructorTypeMunger)) {
            return false;
        }
        NewConstructorTypeMunger o = (NewConstructorTypeMunger) other;
        return ((syntheticConstructor == null) ? (o.syntheticConstructor == null) : syntheticConstructor.equals(o.syntheticConstructor));
    }

    private volatile int hashCode = 0;

    @Override
    public int hashCode() {
        if (hashCode == 0) {
            int result = 17;
            result = 37 * result + ((syntheticConstructor == null) ? 0 : syntheticConstructor.hashCode());
            result = 37 * result + ((explicitConstructor == null) ? 0 : explicitConstructor.hashCode());
            hashCode = result;
        }
        return hashCode;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        kind.write(s);
        signature.write(s);
        syntheticConstructor.write(s);
        explicitConstructor.write(s);
        writeSuperMethodsCalled(s);
        writeSourceLocation(s);
        writeOutTypeAliases(s);
    }

    public static ResolvedTypeMunger readConstructor(VersionedDataInputStream s, ISourceContext context) throws IOException {
        ISourceLocation sloc = null;
        ResolvedMember sig = ResolvedMemberImpl.readResolvedMember(s, context);
        ResolvedMember syntheticCtor = ResolvedMemberImpl.readResolvedMember(s, context);
        ResolvedMember explicitCtor = ResolvedMemberImpl.readResolvedMember(s, context);
        Set<ResolvedMember> superMethodsCalled = readSuperMethodsCalled(s);
        sloc = readSourceLocation(s);
        List<String> typeVarAliases = readInTypeAliases(s);
        ResolvedTypeMunger munger = new NewConstructorTypeMunger(sig, syntheticCtor, explicitCtor, superMethodsCalled, typeVarAliases);
        if (sloc != null) {
            munger.setSourceLocation(sloc);
        }
        return munger;
    }

    public ResolvedMember getExplicitConstructor() {
        return explicitConstructor;
    }

    public ResolvedMember getSyntheticConstructor() {
        return syntheticConstructor;
    }

    public void setExplicitConstructor(ResolvedMember explicitConstructor) {
        this.explicitConstructor = explicitConstructor;
        hashCode = 0;
    }

    @Override
    public ResolvedMember getMatchingSyntheticMember(Member member, ResolvedType aspectType) {
        ResolvedMember ret = getSyntheticConstructor();
        if (ResolvedType.matches(ret, member)) {
            return getSignature();
        }
        return super.getMatchingSyntheticMember(member, aspectType);
    }

    public void check(World world) {
        if (getSignature().getDeclaringType().resolve(world).isAspect()) {
            world.showMessage(IMessage.ERROR, WeaverMessages.format(WeaverMessages.ITD_CONS_ON_ASPECT), getSignature().getSourceLocation(), null);
        }
    }

    @Override
    public ResolvedTypeMunger parameterizedFor(ResolvedType target) {
        ResolvedType genericType = target;
        if (target.isRawType() || target.isParameterizedType()) {
            genericType = genericType.getGenericType();
        }
        ResolvedMember parameterizedSignature = null;
        if (target.isGenericType()) {
            TypeVariable[] vars = target.getTypeVariables();
            UnresolvedTypeVariableReferenceType[] varRefs = new UnresolvedTypeVariableReferenceType[vars.length];
            for (int i = 0; i < vars.length; i++) {
                varRefs[i] = new UnresolvedTypeVariableReferenceType(vars[i]);
            }
            parameterizedSignature = getSignature().parameterizedWith(varRefs, genericType, true, typeVariableAliases);
        } else {
            parameterizedSignature = getSignature().parameterizedWith(target.getTypeParameters(), genericType, target.isParameterizedType(), typeVariableAliases);
        }
        NewConstructorTypeMunger nctm = new NewConstructorTypeMunger(parameterizedSignature, syntheticConstructor, explicitConstructor, getSuperMethodsCalled(), typeVariableAliases);
        nctm.setSourceLocation(getSourceLocation());
        return nctm;
    }
}
