package org.aspectj.weaver;

import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.patterns.PerTypeWithin;
import org.aspectj.weaver.patterns.Pointcut;

import java.io.IOException;

public class PerTypeWithinTargetTypeMunger extends ResolvedTypeMunger {

    private UnresolvedType aspectType;

    private PerTypeWithin testPointcut;

    public PerTypeWithinTargetTypeMunger(UnresolvedType aspectType, PerTypeWithin testPointcut) {
        super(PerTypeWithinInterface, null);
        this.aspectType = aspectType;
        this.testPointcut = testPointcut;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PerTypeWithinTargetTypeMunger)) {
            return false;
        }
        PerTypeWithinTargetTypeMunger o = (PerTypeWithinTargetTypeMunger) other;
        return ((o.testPointcut == null) ? (testPointcut == null) : testPointcut.equals(o.testPointcut)) && ((o.aspectType == null) ? (aspectType == null) : aspectType.equals(o.aspectType));
    }

    private volatile int hashCode = 0;

    @Override
    public int hashCode() {
        if (hashCode == 0) {
            int result = 17;
            result = 37 * result + ((testPointcut == null) ? 0 : testPointcut.hashCode());
            result = 37 * result + ((aspectType == null) ? 0 : aspectType.hashCode());
            hashCode = result;
        }
        return hashCode;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        throw new RuntimeException("shouldn't be serialized");
    }

    public UnresolvedType getAspectType() {
        return aspectType;
    }

    public Pointcut getTestPointcut() {
        return testPointcut;
    }

    @Override
    public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
        return isWithinType(matchType).alwaysTrue() && !matchType.isInterface() && (matchType.canBeSeenBy(aspectType) || aspectType.isPrivilegedAspect());
    }

    private FuzzyBoolean isWithinType(ResolvedType type) {
        while (type != null) {
            if (testPointcut.getTypePattern().matchesStatically(type)) {
                return FuzzyBoolean.YES;
            }
            type = type.getDeclaringType();
        }
        return FuzzyBoolean.NO;
    }
}
