package org.aspectj.weaver;

import java.io.IOException;

public class PrivilegedAccessMunger extends ResolvedTypeMunger {

    public boolean shortSyntax = false;

    public PrivilegedAccessMunger(ResolvedMember member, boolean shortSyntax) {
        super(PrivilegedAccess, member);
        this.shortSyntax = shortSyntax;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        throw new RuntimeException("should not be serialized");
    }

    public ResolvedMember getMember() {
        return getSignature();
    }

    @Override
    public ResolvedMember getMatchingSyntheticMember(Member member, ResolvedType aspectType) {
        ResolvedMember ret;
        if (getSignature().getKind() == Member.FIELD) {
            ret = AjcMemberMaker.privilegedAccessMethodForFieldGet(aspectType, getSignature(), shortSyntax);
            if (ResolvedType.matches(ret, member)) {
                return getSignature();
            }
            ret = AjcMemberMaker.privilegedAccessMethodForFieldSet(aspectType, getSignature(), shortSyntax);
            if (ResolvedType.matches(ret, member)) {
                return getSignature();
            }
        } else {
            ret = AjcMemberMaker.privilegedAccessMethodForMethod(aspectType, getSignature());
            if (ResolvedType.matches(ret, member)) {
                return getSignature();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PrivilegedAccessMunger)) {
            return false;
        }
        PrivilegedAccessMunger o = (PrivilegedAccessMunger) other;
        return kind.equals(o.kind) && ((o.signature == null) ? (signature == null) : signature.equals(o.signature)) && ((o.declaredSignature == null) ? (declaredSignature == null) : declaredSignature.equals(o.declaredSignature)) && ((o.typeVariableAliases == null) ? (typeVariableAliases == null) : typeVariableAliases.equals(o.typeVariableAliases));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + kind.hashCode();
        result = 37 * result + ((signature == null) ? 0 : signature.hashCode());
        result = 37 * result + ((declaredSignature == null) ? 0 : declaredSignature.hashCode());
        result = 37 * result + ((typeVariableAliases == null) ? 0 : typeVariableAliases.hashCode());
        return result;
    }

    @Override
    public boolean existsToSupportShadowMunging() {
        return true;
    }
}
