package org.aspectj.weaver;

public class ResolvableTypeList {

    public int length;

    private World world;

    private UnresolvedType[] types;

    public ResolvableTypeList(World world, UnresolvedType[] unresolvedTypes) {
        length = unresolvedTypes.length;
        types = unresolvedTypes;
        this.world = world;
    }

    public ResolvedType getResolved(int nameIndex) {
        UnresolvedType ut = types[nameIndex];
        if (!(ut instanceof ResolvedType)) {
            types[nameIndex] = world.resolve(ut);
            return (ResolvedType) types[nameIndex];
        } else {
            return (ResolvedType) ut;
        }
    }
}
