package org.aspectj.weaver;

import org.aspectj.bridge.ISourceLocation;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface ResolvedMember extends Member, AnnotatedElement, TypeVariableDeclaringElement {

    ResolvedMember[] NONE = new ResolvedMember[0];

    int getModifiers(World world);

    int getModifiers();

    UnresolvedType[] getExceptions(World world);

    UnresolvedType[] getExceptions();

    ShadowMunger getAssociatedShadowMunger();

    boolean isAjSynthetic();

    boolean isCompatibleWith(Member am);

    boolean hasAnnotation(UnresolvedType ofType);

    AnnotationAJ[] getAnnotations();

    ResolvedType[] getAnnotationTypes();

    void setAnnotationTypes(ResolvedType[] annotationtypes);

    void addAnnotation(AnnotationAJ annotation);

    boolean isBridgeMethod();

    boolean isVarargsMethod();

    boolean isSynthetic();

    void write(CompressingDataOutputStream s) throws IOException;

    ISourceContext getSourceContext(World world);

    String[] getParameterNames();

    void setParameterNames(String[] names);

    AnnotationAJ[][] getParameterAnnotations();

    ResolvedType[][] getParameterAnnotationTypes();

    String getAnnotationDefaultValue();

    String getParameterSignatureErased();

    String getSignatureErased();

    String[] getParameterNames(World world);

    AjAttribute.EffectiveSignatureAttribute getEffectiveSignature();

    ISourceLocation getSourceLocation();

    int getStart();

    int getEnd();

    ISourceContext getSourceContext();

    void setPosition(int sourceStart, int sourceEnd);

    void setSourceContext(ISourceContext sourceContext);

    boolean isAbstract();

    boolean isPublic();

    boolean isDefault();

    boolean isVisible(ResolvedType fromType);

    void setCheckedExceptions(UnresolvedType[] checkedExceptions);

    void setAnnotatedElsewhere(boolean b);

    boolean isAnnotatedElsewhere();

    String toGenericString();

    String toDebugString();

    boolean hasBackingGenericMember();

    ResolvedMember getBackingGenericMember();

    UnresolvedType getGenericReturnType();

    UnresolvedType[] getGenericParameterTypes();

    boolean equalsApartFromDeclaringType(Object other);

    ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized);

    ResolvedMemberImpl parameterizedWith(UnresolvedType[] typeParameters, ResolvedType newDeclaringType, boolean isParameterized, List<String> aliases);

    void setTypeVariables(TypeVariable[] types);

    TypeVariable[] getTypeVariables();

    boolean matches(ResolvedMember aCandidateMatch, boolean ignoreGenerics);

    void evictWeavingState();

    ResolvedMember parameterizedWith(Map<String, UnresolvedType> m, World w);

    boolean isDefaultConstructor();

    void setAnnotations(AnnotationAJ[] annotations);
}
