package org.aspectj.weaver;

public enum RuntimeVersion {

    V1_2("1.2"), V1_5("1.5"), V1_6_10("1.6.10"), V1_9("1.9");

    private String[] aliases = null;

    RuntimeVersion(String... aliases) {
        this.aliases = aliases;
    }

    public static RuntimeVersion getVersionFor(String version) {
        for (RuntimeVersion candidateVersion : values()) {
            if (candidateVersion.name().equals(version)) {
                return candidateVersion;
            }
            if (candidateVersion.aliases != null) {
                for (String alias : candidateVersion.aliases) {
                    if (alias.equals(version)) {
                        return candidateVersion;
                    }
                }
            }
        }
        return null;
    }

    public boolean isThisVersionOrLater(RuntimeVersion version) {
        return this.compareTo(version) >= 0;
    }
}
