package org.aspectj.weaver;

import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;

import java.io.File;
import java.util.Arrays;

public class SourceContextImpl implements ISourceContext {

    private int[] lineBreaks;

    String sourceFilename;

    public SourceContextImpl(AbstractReferenceTypeDelegate delegate) {
        sourceFilename = delegate.getSourcefilename();
    }

    public void configureFromAttribute(String name, int[] linebreaks) {
        this.sourceFilename = name;
        this.lineBreaks = linebreaks;
    }

    public void setSourceFileName(String name) {
        sourceFilename = name;
    }

    private File getSourceFile() {
        return new File(sourceFilename);
    }

    public void tidy() {
    }

    public int getOffset() {
        return 0;
    }

    public ISourceLocation makeSourceLocation(IHasPosition position) {
        if (lineBreaks != null) {
            int line = Arrays.binarySearch(lineBreaks, position.getStart());
            if (line < 0) {
                line = -line;
            }
            return new SourceLocation(getSourceFile(), line);
        } else {
            return new SourceLocation(getSourceFile(), 0);
        }
    }

    public ISourceLocation makeSourceLocation(int line, int offset) {
        if (line < 0) {
            line = 0;
        }
        SourceLocation sl = new SourceLocation(getSourceFile(), line);
        if (offset > 0) {
            sl.setOffset(offset);
        } else {
            if (lineBreaks != null) {
                int likelyOffset = 0;
                if (line > 0 && line < lineBreaks.length) {
                    likelyOffset = lineBreaks[line - 1] + 1;
                }
                sl.setOffset(likelyOffset);
            }
        }
        return sl;
    }

    public final static ISourceContext UNKNOWN_SOURCE_CONTEXT = new ISourceContext() {

        public ISourceLocation makeSourceLocation(IHasPosition position) {
            return null;
        }

        public ISourceLocation makeSourceLocation(int line, int offset) {
            return null;
        }

        public int getOffset() {
            return 0;
        }

        public void tidy() {
        }
    };
}
