package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StandardAnnotation extends AbstractAnnotationAJ {

    private final boolean isRuntimeVisible;

    private List<AnnotationNameValuePair> nvPairs = null;

    public StandardAnnotation(ResolvedType type, boolean isRuntimeVisible) {
        super(type);
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public boolean isRuntimeVisible() {
        return isRuntimeVisible;
    }

    public String stringify() {
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(type.getClassName());
        if (hasNameValuePairs()) {
            sb.append("(");
            for (AnnotationNameValuePair nvPair : nvPairs) {
                sb.append(nvPair.stringify());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Anno[" + getTypeSignature() + " " + (isRuntimeVisible ? "rVis" : "rInvis"));
        if (nvPairs != null) {
            sb.append(" ");
            for (Iterator<AnnotationNameValuePair> iter = nvPairs.iterator(); iter.hasNext(); ) {
                AnnotationNameValuePair element = iter.next();
                sb.append(element.toString());
                if (iter.hasNext()) {
                    sb.append(",");
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasNamedValue(String n) {
        if (nvPairs == null) {
            return false;
        }
        for (AnnotationNameValuePair pair : nvPairs) {
            if (pair.getName().equals(n)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasNameValuePair(String n, String v) {
        if (nvPairs == null) {
            return false;
        }
        for (AnnotationNameValuePair pair : nvPairs) {
            if (pair.getName().equals(n)) {
                if (pair.getValue().stringify().equals(v)) {
                    return true;
                }
            }
        }
        return false;
    }

    public Set<String> getTargets() {
        if (!type.equals(UnresolvedType.AT_TARGET)) {
            return Collections.emptySet();
        }
        AnnotationNameValuePair nvp = nvPairs.get(0);
        ArrayAnnotationValue aav = (ArrayAnnotationValue) nvp.getValue();
        AnnotationValue[] avs = aav.getValues();
        Set<String> targets = new HashSet<>();
        for (AnnotationValue av : avs) {
            EnumAnnotationValue value = (EnumAnnotationValue) av;
            targets.add(value.getValue());
        }
        return targets;
    }

    public List<AnnotationNameValuePair> getNameValuePairs() {
        return nvPairs;
    }

    public boolean hasNameValuePairs() {
        return nvPairs != null && nvPairs.size() != 0;
    }

    public void addNameValuePair(AnnotationNameValuePair pair) {
        if (nvPairs == null) {
            nvPairs = new ArrayList<>();
        }
        nvPairs.add(pair);
    }

    public String getStringFormOfValue(String name) {
        if (hasNameValuePairs()) {
            for (AnnotationNameValuePair nvPair : nvPairs) {
                if (nvPair.getName().equals(name)) {
                    return nvPair.getValue().stringify();
                }
            }
        }
        return null;
    }
}
