package org.aspectj.weaver;

public class UnresolvedTypeVariableReferenceType extends UnresolvedType implements TypeVariableReference {

    private TypeVariable typeVariable;

    public UnresolvedTypeVariableReferenceType() {
        super("Ljava/lang/Object;");
    }

    public UnresolvedTypeVariableReferenceType(TypeVariable aTypeVariable) {
        super("T" + aTypeVariable.getName() + ";", aTypeVariable.getFirstBound().getErasureSignature());
        this.typeVariable = aTypeVariable;
    }

    public void setTypeVariable(TypeVariable aTypeVariable) {
        this.signature = "T" + aTypeVariable.getName() + ";";
        this.signatureErasure = aTypeVariable.getFirstBound().getErasureSignature();
        this.typeVariable = aTypeVariable;
        this.typeKind = TypeKind.TYPE_VARIABLE;
    }

    @Override
    public ResolvedType resolve(World world) {
        TypeVariableDeclaringElement typeVariableScope = world.getTypeVariableLookupScope();
        TypeVariable resolvedTypeVariable = null;
        TypeVariableReferenceType tvrt = null;
        if (typeVariableScope == null) {
            resolvedTypeVariable = typeVariable.resolve(world);
            tvrt = new TypeVariableReferenceType(resolvedTypeVariable, world);
        } else {
            boolean foundOK = false;
            resolvedTypeVariable = typeVariableScope.getTypeVariableNamed(typeVariable.getName());
            if (resolvedTypeVariable == null) {
                resolvedTypeVariable = typeVariable.resolve(world);
            } else {
                foundOK = true;
            }
            tvrt = new TypeVariableReferenceType(resolvedTypeVariable, world);
        }
        return tvrt;
    }

    @Override
    public boolean isTypeVariableReference() {
        return true;
    }

    public TypeVariable getTypeVariable() {
        return typeVariable;
    }

    @Override
    public String toString() {
        if (typeVariable == null) {
            return "<type variable not set!>";
        } else {
            return "T" + typeVariable.getName() + ";";
        }
    }

    @Override
    public String toDebugString() {
        return typeVariable.getName();
    }

    @Override
    public String getErasureSignature() {
        return typeVariable.getFirstBound().getSignature();
    }
}
