package org.aspectj.weaver;

public class Utils {

    public static boolean isSuppressing(AnnotationAJ[] anns, String lintkey) {
        if (anns == null) {
            return false;
        }
        for (AnnotationAJ ann : anns) {
            if (UnresolvedType.SUPPRESS_AJ_WARNINGS.getSignature().equals(ann.getTypeSignature())) {
                String value = ann.getStringFormOfValue("value");
                if (value == null || value.contains(lintkey)) {
                    return true;
                }
            }
        }
        return false;
    }
}
