package org.aspectj.weaver;

import org.aspectj.weaver.AjAttribute.WeaverVersionInfo;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VersionedDataInputStream extends DataInputStream {

    private WeaverVersionInfo version = new WeaverVersionInfo();

    private ConstantPoolReader constantPoolReader;

    public VersionedDataInputStream(InputStream is, ConstantPoolReader constantPoolReader) {
        super(is);
        this.constantPoolReader = constantPoolReader;
    }

    public int getMajorVersion() {
        return version.getMajorVersion();
    }

    public int getMinorVersion() {
        return version.getMinorVersion();
    }

    public long getBuildstamp() {
        return version.getBuildstamp();
    }

    public void setVersion(WeaverVersionInfo version) {
        this.version = version;
    }

    public String readUtf8(int cpIndex) {
        if (constantPoolReader == null) {
            throw new IllegalStateException();
        }
        if (cpIndex < 0) {
            throw new IllegalStateException(cpIndex + "");
        }
        return constantPoolReader.readUtf8(cpIndex);
    }

    public boolean canDecompress() {
        return constantPoolReader != null;
    }

    public boolean isAtLeast169() {
        return getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_AJ169;
    }

    public String readPath() throws IOException {
        return readUtf8(readShort());
    }

    public String readSignature() throws IOException {
        return readUtf8(readShort());
    }

    public UnresolvedType readSignatureAsUnresolvedType() throws IOException {
        return UnresolvedType.forSignature(readUtf8(readShort()));
    }

    public String toString() {
        return "VersionedDataInputStream: version=" + version + " constantPoolReader?" + (constantPoolReader != null);
    }
}
