package org.aspectj.weaver;

import java.lang.ref.WeakReference;

public class WeakClassLoaderReference {

    protected final int hashcode;

    private final WeakReference<ClassLoader> loaderRef;

    public WeakClassLoaderReference(ClassLoader loader) {
        loaderRef = new WeakReference<>(loader);
        if (loader == null) {
            hashcode = System.identityHashCode(this);
        } else {
            hashcode = loader.hashCode() * 37;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader instance = (ClassLoader) loaderRef.get();
        return instance;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WeakClassLoaderReference))
            return false;
        WeakClassLoaderReference other = (WeakClassLoaderReference) obj;
        return (other.hashcode == hashcode);
    }

    public int hashCode() {
        return hashcode;
    }
}
