package org.aspectj.weaver;

public class WildcardedUnresolvedType extends UnresolvedType {

    public static final int UNBOUND = 0;

    public static final int EXTENDS = 1;

    public static final int SUPER = 2;

    public static final WildcardedUnresolvedType QUESTIONMARK = new WildcardedUnresolvedType("*", UnresolvedType.OBJECT, null);

    private int boundKind = UNBOUND;

    private UnresolvedType lowerBound;

    private UnresolvedType upperBound;

    public WildcardedUnresolvedType(String signature, UnresolvedType upperBound, UnresolvedType lowerBound) {
        super(signature, (upperBound == null ? UnresolvedType.OBJECT.signature : upperBound.signatureErasure));
        this.typeKind = TypeKind.WILDCARD;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        if (signature.charAt(0) == '-') {
            boundKind = SUPER;
        }
        if (signature.charAt(0) == '+') {
            boundKind = EXTENDS;
        }
    }

    public UnresolvedType getUpperBound() {
        return upperBound;
    }

    public UnresolvedType getLowerBound() {
        return lowerBound;
    }

    public boolean isExtends() {
        return boundKind == EXTENDS;
    }

    public boolean isSuper() {
        return boundKind == SUPER;
    }

    public boolean isUnbound() {
        return boundKind == UNBOUND;
    }
}
