package org.aspectj.weaver.ast;

import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;

public class CallExpr extends Expr {

    private final Member method;

    private final Expr[] args;

    private final ResolvedType returnType;

    public CallExpr(Member m, Expr[] args, ResolvedType returnType) {
        super();
        this.method = m;
        this.args = args;
        this.returnType = returnType;
    }

    public void accept(IExprVisitor v) {
        v.visit(this);
    }

    public Expr[] getArgs() {
        return args;
    }

    public Member getMethod() {
        return method;
    }

    public ResolvedType getType() {
        return returnType;
    }
}
