package org.aspectj.weaver.ast;

import org.aspectj.weaver.Member;

public class FieldGetCall extends Test {

    private final Member field;

    private final Member method;

    private final Expr[] args;

    public FieldGetCall(Member f, Member m, Expr[] args) {
        super();
        this.field = f;
        this.method = m;
        this.args = args;
    }

    public void accept(ITestVisitor v) {
        v.visit(this);
    }

    public Expr[] getArgs() {
        return args;
    }

    public Member getMethod() {
        return method;
    }

    public Member getField() {
        return field;
    }
}
