package org.aspectj.weaver.ast;

import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;

public class HasAnnotation extends Test {

    private Var v;

    private ResolvedType annType;

    public HasAnnotation(Var v, ResolvedType annType) {
        super();
        this.v = v;
        this.annType = annType;
    }

    public void accept(ITestVisitor v) {
        v.visit(this);
    }

    public String toString() {
        return "(" + v + " has annotation @" + annType + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof HasAnnotation) {
            HasAnnotation o = (HasAnnotation) other;
            return o.v.equals(v) && o.annType.equals(annType);
        } else {
            return false;
        }
    }

    public int hashCode() {
        return v.hashCode() * 37 + annType.hashCode();
    }

    public Var getVar() {
        return v;
    }

    public UnresolvedType getAnnotationType() {
        return annType;
    }
}
