package org.aspectj.weaver.bcel;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedType;

public class BcelCflowAccessVar extends BcelVar {

    private Member stackField;

    private int index;

    public BcelCflowAccessVar(ResolvedType type, Member stackField, int index) {
        super(type, 0);
        this.stackField = stackField;
        this.index = index;
    }

    public String toString() {
        return "BcelCflowAccessVar(" + getType() + " " + stackField + "." + index + ")";
    }

    public Instruction createLoad(InstructionFactory fact) {
        throw new RuntimeException("unimplemented");
    }

    public Instruction createStore(InstructionFactory fact) {
        throw new RuntimeException("unimplemented");
    }

    public InstructionList createCopyFrom(InstructionFactory fact, int oldSlot) {
        throw new RuntimeException("unimplemented");
    }

    public void appendLoad(InstructionList il, InstructionFactory fact) {
        il.append(createLoadInstructions(getType(), fact));
    }

    public InstructionList createLoadInstructions(ResolvedType toType, InstructionFactory fact) {
        InstructionList il = new InstructionList();
        il.append(Utility.createGet(fact, stackField));
        il.append(Utility.createConstant(fact, index));
        il.append(fact.createInvoke(NameMangler.CFLOW_STACK_TYPE, "get", Type.OBJECT, new Type[]{Type.INT}, Constants.INVOKEVIRTUAL));
        il.append(Utility.createConversion(fact, Type.OBJECT, BcelWorld.makeBcelType(toType)));
        return il;
    }

    public void appendLoadAndConvert(InstructionList il, InstructionFactory fact, ResolvedType toType) {
        il.append(createLoadInstructions(toType, fact));
    }

    public void insertLoad(InstructionList il, InstructionFactory fact) {
        il.insert(createLoadInstructions(getType(), fact));
    }
}
