package org.aspectj.weaver.bcel;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.generic.FieldGen;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;

public class BcelCflowCounterFieldAdder extends BcelTypeMunger {

    private ResolvedMember cflowCounterField;

    public BcelCflowCounterFieldAdder(ResolvedMember cflowCounterField) {
        super(null, (ResolvedType) cflowCounterField.getDeclaringType());
        this.cflowCounterField = cflowCounterField;
    }

    public boolean munge(BcelClassWeaver weaver) {
        LazyClassGen gen = weaver.getLazyClassGen();
        if (!gen.getType().equals(cflowCounterField.getDeclaringType()))
            return false;
        FieldGen f = new FieldGen(cflowCounterField.getModifiers(), BcelWorld.makeBcelType(cflowCounterField.getReturnType()), cflowCounterField.getName(), gen.getConstantPool());
        gen.addField(f, getSourceLocation());
        LazyMethodGen clinit = gen.getAjcPreClinit();
        InstructionList setup = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        setup.append(fact.createNew(new ObjectType(NameMangler.CFLOW_COUNTER_TYPE)));
        setup.append(InstructionFactory.createDup(1));
        setup.append(fact.createInvoke(NameMangler.CFLOW_COUNTER_TYPE, "<init>", Type.VOID, Type.NO_ARGS, Constants.INVOKESPECIAL));
        setup.append(Utility.createSet(fact, cflowCounterField));
        clinit.getBody().insert(setup);
        return true;
    }

    public ResolvedMember getMatchingSyntheticMember(Member member) {
        return null;
    }

    public ResolvedMember getSignature() {
        return cflowCounterField;
    }

    public boolean matches(ResolvedType onType) {
        return onType.equals(cflowCounterField.getDeclaringType());
    }

    public boolean existsToSupportShadowMunging() {
        return true;
    }

    public String toString() {
        return "(BcelTypeMunger: CflowField " + cflowCounterField.getDeclaringType().getName() + " " + cflowCounterField.getName() + ")";
    }
}
