package org.aspectj.weaver.bcel;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.weaver.ResolvedType;

public class BcelFieldRef extends BcelVar {

    private String className, fieldName;

    public BcelFieldRef(ResolvedType type, String className, String fieldName) {
        super(type, 0);
        this.className = className;
        this.fieldName = fieldName;
    }

    public String toString() {
        return "BcelFieldRef(" + getType() + " " + className + "." + fieldName + ")";
    }

    public Instruction createLoad(InstructionFactory fact) {
        return fact.createFieldAccess(className, fieldName, BcelWorld.makeBcelType(getType()), Constants.GETSTATIC);
    }

    public Instruction createStore(InstructionFactory fact) {
        return fact.createFieldAccess(className, fieldName, BcelWorld.makeBcelType(getType()), Constants.PUTSTATIC);
    }

    public InstructionList createCopyFrom(InstructionFactory fact, int oldSlot) {
        throw new RuntimeException("unimplemented");
    }
}
