package org.aspectj.weaver.bcel.asm;

import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

import aj.org.objectweb.asm.ClassReader;
import aj.org.objectweb.asm.ClassVisitor;
import aj.org.objectweb.asm.ClassWriter;
import aj.org.objectweb.asm.MethodVisitor;
import aj.org.objectweb.asm.Opcodes;

public class StackMapAdder {

    public static byte[] addStackMaps(World world, String classname, byte[] data) {
        try {
            ClassReader cr = new ClassReader(data);
            ClassWriter cw = new AspectJConnectClassWriter(cr, world);
            ClassVisitor cv = new AspectJClassVisitor(cw);
            cr.accept(cv, 0);
            return cw.toByteArray();
        } catch (Throwable t) {
            System.err.println("AspectJ Internal Error: unable to add stackmap attributes to class '" + classname + "'. " + t.getMessage());
            t.printStackTrace();
            AsmDetector.isAsmAround = false;
            AsmDetector.reasonAsmIsMissing = t;
            return data;
        }
    }

    private static class AspectJClassVisitor extends ClassVisitor {

        public AspectJClassVisitor(ClassVisitor classwriter) {
            super(Opcodes.ASM9, classwriter);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new AJMethodVisitor(mv);
        }

        static class AJMethodVisitor extends MethodVisitor {

            public AJMethodVisitor(MethodVisitor mv) {
                super(Opcodes.ASM9, mv);
            }
        }
    }

    private static class AspectJConnectClassWriter extends ClassWriter {

        private final World world;

        public AspectJConnectClassWriter(ClassReader cr, World w) {
            super(cr, ClassWriter.COMPUTE_FRAMES);
            this.world = w;
        }

        @Override
        protected String getCommonSuperClass(final String type1, final String type2) {
            ResolvedType resolvedType1 = world.resolve(UnresolvedType.forName(type1.replace('/', '.')));
            ResolvedType resolvedType2 = world.resolve(UnresolvedType.forName(type2.replace('/', '.')));
            if (resolvedType1.isAssignableFrom(resolvedType2)) {
                return type1;
            }
            if (resolvedType2.isAssignableFrom(resolvedType1)) {
                return type2;
            }
            if (resolvedType1.isInterface() || resolvedType2.isInterface()) {
                return "java/lang/Object";
            } else {
                do {
                    resolvedType1 = resolvedType1.getSuperclass();
                    if (resolvedType1 == null) {
                        return "java/lang/Object";
                    }
                    if (resolvedType1.isParameterizedOrGenericType()) {
                        resolvedType1 = resolvedType1.getRawType();
                    }
                } while (!resolvedType1.isAssignableFrom(resolvedType2));
                return resolvedType1.getRawName().replace('.', '/');
            }
        }
    }
}
