package org.aspectj.weaver.loadtime;

import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class DefaultMessageHandler implements IMessageHandler {

    boolean isVerbose = false;

    boolean isDebug = false;

    boolean showWeaveInfo = false;

    boolean showWarn = true;

    public boolean handleMessage(IMessage message) throws AbortException {
        if (isIgnoring(message.getKind())) {
            return false;
        } else {
            return SYSTEM_ERR.handleMessage(message);
        }
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        if (kind.equals(IMessage.WEAVEINFO)) {
            return !showWeaveInfo;
        }
        if (kind.isSameOrLessThan(IMessage.INFO)) {
            return !isVerbose;
        }
        if (kind.isSameOrLessThan(IMessage.DEBUG)) {
            return !isDebug;
        }
        return !showWarn;
    }

    public void dontIgnore(IMessage.Kind kind) {
        if (kind.equals(IMessage.WEAVEINFO)) {
            showWeaveInfo = true;
        } else if (kind.equals(IMessage.DEBUG)) {
            isVerbose = true;
        } else if (kind.equals(IMessage.WARNING)) {
            showWarn = false;
        }
    }

    public void ignore(IMessage.Kind kind) {
        if (kind.equals(IMessage.WEAVEINFO)) {
            showWeaveInfo = false;
        } else if (kind.equals(IMessage.DEBUG)) {
            isVerbose = false;
        } else if (kind.equals(IMessage.WARNING)) {
            showWarn = true;
        }
    }
}
