package org.aspectj.weaver.loadtime;

import org.aspectj.weaver.bcel.BcelWeakClassLoaderReference;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingAdaptor;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public class DefaultWeavingContext implements IWeavingContext {

    protected BcelWeakClassLoaderReference loaderRef;

    private String shortName;

    private static Trace trace = TraceFactory.getTraceFactory().getTrace(DefaultWeavingContext.class);

    public DefaultWeavingContext(ClassLoader loader) {
        super();
        this.loaderRef = new BcelWeakClassLoaderReference(loader);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return getClassLoader().getResources(name);
    }

    public String getBundleIdFromURL(URL url) {
        return "";
    }

    public String getClassLoaderName() {
        ClassLoader loader = getClassLoader();
        return ((loader != null) ? loader.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(loader)) : "null");
    }

    public ClassLoader getClassLoader() {
        return loaderRef.getClassLoader();
    }

    public String getFile(URL url) {
        return url.getFile();
    }

    public String getId() {
        if (shortName == null) {
            shortName = getClassLoaderName().replace('$', '.');
            int index = shortName.lastIndexOf(".");
            if (index != -1) {
                shortName = shortName.substring(index + 1);
            }
        }
        return shortName;
    }

    public String getSuffix() {
        return getClassLoaderName();
    }

    public boolean isLocallyDefined(String classname) {
        String asResource = classname.replace('.', '/').concat(".class");
        ClassLoader loader = getClassLoader();
        URL localURL = loader.getResource(asResource);
        if (localURL == null) {
            return false;
        }
        boolean isLocallyDefined = true;
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            URL parentURL = parent.getResource(asResource);
            if (localURL.equals(parentURL)) {
                isLocallyDefined = false;
            }
        }
        return isLocallyDefined;
    }

    public List<Definition> getDefinitions(final ClassLoader loader, final WeavingAdaptor adaptor) {
        if (trace.isTraceEnabled()) {
            trace.enter("getDefinitions", this, new Object[]{"goo", adaptor});
        }
        List<Definition> definitions = ((ClassLoaderWeavingAdaptor) adaptor).parseDefinitions(loader);
        if (trace.isTraceEnabled()) {
            trace.exit("getDefinitions", definitions);
        }
        return definitions;
    }
}
