package org.aspectj.weaver.loadtime;

import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.tools.WeavingAdaptor;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;

public interface IWeavingContext {

    Enumeration<URL> getResources(String name) throws IOException;

    String getBundleIdFromURL(URL url);

    String getClassLoaderName();

    ClassLoader getClassLoader();

    String getFile(URL url);

    String getId();

    boolean isLocallyDefined(String classname);

    List<Definition> getDefinitions(final ClassLoader loader, WeavingAdaptor adaptor);
}
