package org.aspectj.weaver.patterns;

import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

import java.io.IOException;
import java.util.Map;

public class AnyTypePattern extends TypePattern {

    public AnyTypePattern() {
        super(false, false, new TypePatternList());
    }

    @Override
    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return true;
    }

    @Override
    protected boolean matchesExactly(ResolvedType type) {
        return true;
    }

    @Override
    protected boolean matchesExactly(ResolvedType type, ResolvedType annotatedType) {
        return true;
    }

    @Override
    public FuzzyBoolean matchesInstanceof(ResolvedType type) {
        return FuzzyBoolean.YES;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        s.writeByte(ANY_KEY);
    }

    @Override
    protected boolean matchesSubtypes(ResolvedType type) {
        return true;
    }

    @Override
    public boolean isStar() {
        return true;
    }

    @Override
    public String toString() {
        return "*";
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof AnyTypePattern);
    }

    @Override
    public int hashCode() {
        return 37;
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public TypePattern parameterizeWith(Map<String, UnresolvedType> arg0, World w) {
        return this;
    }
}
