package org.aspectj.weaver.patterns;

import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;

import java.io.IOException;
import java.util.Map;

public abstract class Declare extends PatternNode {

    public static final byte ERROR_OR_WARNING = 1;

    public static final byte PARENTS = 2;

    public static final byte SOFT = 3;

    public static final byte DOMINATES = 4;

    public static final byte ANNOTATION = 5;

    public static final byte PARENTSMIXIN = 6;

    public static final byte TYPE_ERROR_OR_WARNING = 7;

    private ResolvedType declaringType;

    public static Declare read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        byte kind = s.readByte();
        switch (kind) {
            case ERROR_OR_WARNING:
                return DeclareErrorOrWarning.read(s, context);
            case DOMINATES:
                return DeclarePrecedence.read(s, context);
            case PARENTS:
                return DeclareParents.read(s, context);
            case SOFT:
                return DeclareSoft.read(s, context);
            case ANNOTATION:
                return DeclareAnnotation.read(s, context);
            case PARENTSMIXIN:
                return DeclareParentsMixin.read(s, context);
            case TYPE_ERROR_OR_WARNING:
                return DeclareTypeErrorOrWarning.read(s, context);
            default:
                throw new RuntimeException("unimplemented");
        }
    }

    public abstract void resolve(IScope scope);

    public abstract Declare parameterizeWith(Map<String, UnresolvedType> typeVariableBindingMap, World w);

    public abstract boolean isAdviceLike();

    public abstract String getNameSuffix();

    public void setDeclaringType(ResolvedType aType) {
        this.declaringType = aType;
    }

    public ResolvedType getDeclaringType() {
        return declaringType;
    }
}
