package org.aspectj.weaver.patterns;

import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.World;

import java.io.IOException;
import java.util.Map;

public class EllipsisTypePattern extends TypePattern {

    public EllipsisTypePattern() {
        super(false, false, new TypePatternList());
    }

    @Override
    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return true;
    }

    @Override
    protected boolean matchesExactly(ResolvedType type) {
        return false;
    }

    @Override
    protected boolean matchesExactly(ResolvedType type, ResolvedType annotatedType) {
        return false;
    }

    @Override
    public FuzzyBoolean matchesInstanceof(ResolvedType type) {
        return FuzzyBoolean.NO;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        s.writeByte(ELLIPSIS_KEY);
    }

    @Override
    public boolean isEllipsis() {
        return true;
    }

    @Override
    public String toString() {
        return "..";
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof EllipsisTypePattern);
    }

    @Override
    public int hashCode() {
        return 17 * 37;
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public TypePattern parameterizeWith(Map typeVariableMap, World w) {
        return this;
    }
}
