package org.aspectj.weaver.patterns;

import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Var;

import java.util.Arrays;

public class ExposedState {

    public static final boolean[] NO_ERRONEOUS_VARS = new boolean[0];

    public Var[] vars;

    private boolean[] erroneousVars;

    private Expr aspectInstance;

    private UnresolvedType[] expectedVarTypes;

    private ResolvedType concreteAspect;

    public ExposedState(int size) {
        super();
        if (size == 0) {
            vars = Var.NONE;
            erroneousVars = NO_ERRONEOUS_VARS;
        } else {
            vars = new Var[size];
            erroneousVars = new boolean[size];
        }
    }

    public ExposedState(Member signature) {
        this(signature.getParameterTypes().length);
        expectedVarTypes = new UnresolvedType[signature.getParameterTypes().length];
        if (expectedVarTypes.length > 0) {
            for (int i = 0; i < signature.getParameterTypes().length; i++) {
                expectedVarTypes[i] = signature.getParameterTypes()[i];
            }
        }
    }

    public boolean isFullySetUp() {
        for (Var var : vars) {
            if (var == null)
                return false;
        }
        return true;
    }

    public void set(int i, Var var) {
        if (expectedVarTypes != null) {
            ResolvedType expected = expectedVarTypes[i].resolve(var.getType().getWorld());
            if (!expected.equals(ResolvedType.OBJECT)) {
                if (!expected.isAssignableFrom(var.getType())) {
                    if (!var.getType().isCoerceableFrom(expected)) {
                        return;
                    }
                }
            }
        }
        vars[i] = var;
    }

    public Var get(int i) {
        return vars[i];
    }

    public int size() {
        return vars.length;
    }

    public Expr getAspectInstance() {
        return aspectInstance;
    }

    public void setAspectInstance(Expr aspectInstance) {
        this.aspectInstance = aspectInstance;
    }

    public String toString() {
        return "ExposedState(#Vars=" + vars.length + ",Vars=" + Arrays.asList(vars) + ",AspectInstance=" + aspectInstance + ")";
    }

    public void setErroneousVar(int formalIndex) {
        erroneousVars[formalIndex] = true;
    }

    public boolean isErroneousVar(int formalIndex) {
        return erroneousVars[formalIndex];
    }

    public void setConcreteAspect(ResolvedType concreteAspect) {
        this.concreteAspect = concreteAspect;
    }

    public ResolvedType getConcreteAspect() {
        return this.concreteAspect;
    }
}
