package org.aspectj.weaver.patterns;

import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.Shadow.Kind;
import org.aspectj.weaver.World;

public class FastMatchInfo {

    private Kind kind;

    private ResolvedType type;

    public World world;

    public FastMatchInfo(ResolvedType type, Shadow.Kind kind, World world) {
        this.type = type;
        this.kind = kind;
        this.world = world;
    }

    public Kind getKind() {
        return kind;
    }

    public ResolvedType getType() {
        return type;
    }

    @Override
    public String toString() {
        return "FastMatchInfo [type=" + type.getName() + "] [" + (kind == null ? "AllKinds" : "Kind=" + kind) + "]";
    }
}
