package org.aspectj.weaver.patterns;

import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.UnresolvedType;

public class FormalBinding implements IHasPosition {

    private final UnresolvedType type;

    private final String name;

    private final int index;

    private final int start, end;

    public FormalBinding(UnresolvedType type, String name, int index, int start, int end) {
        this.type = type;
        this.name = name;
        this.index = index;
        this.start = start;
        this.end = end;
    }

    public FormalBinding(UnresolvedType type, int index) {
        this(type, "unknown", index, 0, 0);
    }

    public FormalBinding(UnresolvedType type, String name, int index) {
        this(type, name, index, 0, 0);
    }

    public String toString() {
        return type.toString() + ":" + index;
    }

    public int getEnd() {
        return end;
    }

    public int getStart() {
        return start;
    }

    public int getIndex() {
        return index;
    }

    public String getName() {
        return name;
    }

    public UnresolvedType getType() {
        return type;
    }

    public static final FormalBinding[] NONE = new FormalBinding[0];

    public static class ImplicitFormalBinding extends FormalBinding {

        public ImplicitFormalBinding(UnresolvedType type, String name, int index) {
            super(type, name, index);
        }
    }
}
