package org.aspectj.weaver.patterns;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public interface IScope {

    UnresolvedType lookupType(String name, IHasPosition location);

    World getWorld();

    ResolvedType getEnclosingType();

    IMessageHandler getMessageHandler();

    FormalBinding lookupFormal(String name);

    FormalBinding getFormal(int i);

    int getFormalCount();

    String[] getImportedPrefixes();

    String[] getImportedNames();

    void message(IMessage.Kind kind, IHasPosition location, String message);

    void message(IMessage.Kind kind, IHasPosition location1, IHasPosition location2, String message);

    void message(IMessage aMessage);
}
