package org.aspectj.weaver.patterns;

import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

import java.io.IOException;
import java.util.Map;

public class NoTypePattern extends TypePattern {

    public NoTypePattern() {
        super(false, false, new TypePatternList());
    }

    @Override
    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return false;
    }

    @Override
    protected boolean matchesExactly(ResolvedType type) {
        return false;
    }

    @Override
    protected boolean matchesExactly(ResolvedType type, ResolvedType annotatedType) {
        return false;
    }

    @Override
    public FuzzyBoolean matchesInstanceof(ResolvedType type) {
        return FuzzyBoolean.NO;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        s.writeByte(NO_KEY);
    }

    @Override
    protected boolean matchesSubtypes(ResolvedType type) {
        return false;
    }

    @Override
    public boolean isStar() {
        return false;
    }

    @Override
    public String toString() {
        return "<nothing>";
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof NoTypePattern);
    }

    @Override
    public int hashCode() {
        return 17 * 37 * 37;
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public TypePattern parameterizeWith(Map<String, UnresolvedType> arg0, World w) {
        return this;
    }
}
