package org.aspectj.weaver.patterns;

import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;

import java.io.IOException;
import java.util.Map;

public class PerSingleton extends PerClause {

    private ResolvedMember perSingletonAspectOfMethod;

    public PerSingleton() {
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS_BITS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.YES;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        return FuzzyBoolean.YES;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
    }

    public Pointcut parameterizeWith(Map<String, UnresolvedType> typeVariableMap, World w) {
        return this;
    }

    public Test findResidueInternal(Shadow shadow, ExposedState state) {
        if (perSingletonAspectOfMethod == null) {
            perSingletonAspectOfMethod = AjcMemberMaker.perSingletonAspectOfMethod(inAspect);
        }
        Expr myInstance = Expr.makeCallExpr(perSingletonAspectOfMethod, Expr.NONE, inAspect);
        state.setAspectInstance(myInstance);
        return Literal.TRUE;
    }

    public PerClause concretize(ResolvedType inAspect) {
        PerSingleton ret = new PerSingleton();
        ret.copyLocationFrom(this);
        World world = inAspect.getWorld();
        ret.inAspect = inAspect;
        if (inAspect.isAnnotationStyleAspect() && !inAspect.isAbstract()) {
            if (getKind() == SINGLETON) {
                inAspect.crosscuttingMembers.addTypeMunger(world.getWeavingSupport().makePerClauseAspect(inAspect, getKind()));
            } else {
                inAspect.crosscuttingMembers.addLateTypeMunger(world.getWeavingSupport().makePerClauseAspect(inAspect, getKind()));
            }
        }
        if (inAspect.isAnnotationStyleAspect() && !inAspect.getWorld().isXnoInline()) {
            inAspect.crosscuttingMembers.addTypeMunger(world.getWeavingSupport().createAccessForInlineMunger(inAspect));
        }
        return ret;
    }

    public void write(CompressingDataOutputStream s) throws IOException {
        SINGLETON.write(s);
        writeLocation(s);
    }

    public static PerClause readPerClause(VersionedDataInputStream s, ISourceContext context) throws IOException {
        PerSingleton ret = new PerSingleton();
        ret.readLocation(context, s);
        return ret;
    }

    public PerClause.Kind getKind() {
        return SINGLETON;
    }

    public String toString() {
        return "persingleton(" + inAspect + ")";
    }

    public String toDeclarationString() {
        return "";
    }

    public boolean equals(Object other) {
        if (!(other instanceof PerSingleton)) {
            return false;
        }
        PerSingleton pc = (PerSingleton) other;
        return ((pc.inAspect == null) ? (inAspect == null) : pc.inAspect.equals(inAspect));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + ((inAspect == null) ? 0 : inAspect.hashCode());
        return result;
    }
}
