package org.aspectj.weaver.patterns;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessage.Kind;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.World;

public class ScopeWithTypeVariables implements IScope {

    private IScope delegateScope;

    private String[] typeVariableNames;

    private UnresolvedTypeVariableReferenceType[] typeVarTypeXs;

    public ScopeWithTypeVariables(String[] typeVarNames, IScope delegate) {
        this.delegateScope = delegate;
        this.typeVariableNames = typeVarNames;
        this.typeVarTypeXs = new UnresolvedTypeVariableReferenceType[typeVarNames.length];
    }

    public UnresolvedType lookupType(String name, IHasPosition location) {
        for (int i = 0; i < typeVariableNames.length; i++) {
            if (typeVariableNames[i].equals(name)) {
                if (typeVarTypeXs[i] == null) {
                    typeVarTypeXs[i] = new UnresolvedTypeVariableReferenceType(new TypeVariable(name));
                }
                return typeVarTypeXs[i];
            }
        }
        return delegateScope.lookupType(name, location);
    }

    public World getWorld() {
        return delegateScope.getWorld();
    }

    public ResolvedType getEnclosingType() {
        return delegateScope.getEnclosingType();
    }

    public IMessageHandler getMessageHandler() {
        return delegateScope.getMessageHandler();
    }

    public FormalBinding lookupFormal(String name) {
        return delegateScope.lookupFormal(name);
    }

    public FormalBinding getFormal(int i) {
        return delegateScope.getFormal(i);
    }

    public int getFormalCount() {
        return delegateScope.getFormalCount();
    }

    public String[] getImportedPrefixes() {
        return delegateScope.getImportedPrefixes();
    }

    public String[] getImportedNames() {
        return delegateScope.getImportedNames();
    }

    public void message(Kind kind, IHasPosition location, String message) {
        delegateScope.message(kind, location, message);
    }

    public void message(Kind kind, IHasPosition location1, IHasPosition location2, String message) {
        delegateScope.message(kind, location1, location2, message);
    }

    public void message(IMessage aMessage) {
        delegateScope.message(aMessage);
    }
}
