package org.aspectj.weaver.patterns;

import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.VersionedDataInputStream;

import java.io.IOException;

public class TypeVariablePatternList extends PatternNode {

    public static final TypeVariablePatternList EMPTY = new TypeVariablePatternList(new TypeVariablePattern[0]);

    private TypeVariablePattern[] patterns;

    public TypeVariablePatternList(TypeVariablePattern[] typeVars) {
        this.patterns = typeVars;
    }

    public TypeVariablePattern[] getTypeVariablePatterns() {
        return this.patterns;
    }

    public TypeVariablePattern lookupTypeVariable(String name) {
        for (TypeVariablePattern pattern : patterns) {
            if (pattern.getName().equals(name)) {
                return pattern;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return ((patterns == null) || (patterns.length == 0));
    }

    public void write(CompressingDataOutputStream s) throws IOException {
        s.writeInt(patterns.length);
        for (TypeVariablePattern pattern : patterns) {
            pattern.write(s);
        }
        writeLocation(s);
    }

    public static TypeVariablePatternList read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        TypeVariablePatternList ret = EMPTY;
        int length = s.readInt();
        if (length > 0) {
            TypeVariablePattern[] patterns = new TypeVariablePattern[length];
            for (int i = 0; i < patterns.length; i++) {
                patterns[i] = TypeVariablePattern.read(s, context);
            }
            ret = new TypeVariablePatternList(patterns);
        }
        ret.readLocation(context, s);
        return ret;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object traverse(PatternNodeVisitor visitor, Object data) {
        Object ret = accept(visitor, data);
        for (TypeVariablePattern pattern : patterns) {
            pattern.traverse(visitor, ret);
        }
        return ret;
    }
}
