package org.aspectj.weaver.reflect;

import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

import java.lang.reflect.Member;

public interface AnnotationFinder {

    void setClassLoader(ClassLoader annotationLoader);

    void setWorld(World aWorld);

    Object getAnnotation(ResolvedType annotationType, Object onObject);

    Object getAnnotationFromMember(ResolvedType annotationType, Member aMember);

    AnnotationAJ getAnnotationOfType(UnresolvedType ofType, Member onMember);

    String getAnnotationDefaultValue(Member onMember);

    Object getAnnotationFromClass(ResolvedType annotationType, Class<?> aClass);

    ResolvedType[] getAnnotations(Member onMember, boolean runtimeAnnotationsOnly);

    ResolvedType[][] getParameterAnnotationTypes(Member onMember);
}
