package org.aspectj.weaver.reflect;

import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutParameter;

public class JoinPointMatchImpl implements JoinPointMatch {

    public final static JoinPointMatch NO_MATCH = new JoinPointMatchImpl();

    private final static PointcutParameter[] NO_BINDINGS = new PointcutParameter[0];

    private boolean match;

    private PointcutParameter[] bindings;

    public JoinPointMatchImpl(PointcutParameter[] bindings) {
        this.match = true;
        this.bindings = bindings;
    }

    private JoinPointMatchImpl() {
        this.match = false;
        this.bindings = NO_BINDINGS;
    }

    public boolean matches() {
        return match;
    }

    public PointcutParameter[] getParameterBindings() {
        return bindings;
    }
}
