package org.aspectj.weaver.tools;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public interface PointcutExpression {

    void setMatchingContext(MatchingContext aMatchContext);

    boolean couldMatchJoinPointsInType(Class aClass);

    boolean mayNeedDynamicTest();

    ShadowMatch matchesMethodExecution(Method aMethod);

    ShadowMatch matchesConstructorExecution(Constructor aConstructor);

    ShadowMatch matchesStaticInitialization(Class aClass);

    ShadowMatch matchesAdviceExecution(Method anAdviceMethod);

    ShadowMatch matchesInitialization(Constructor aConstructor);

    ShadowMatch matchesPreInitialization(Constructor aConstructor);

    ShadowMatch matchesMethodCall(Method aMethod, Member withinCode);

    ShadowMatch matchesMethodCall(Method aMethod, Class callerType);

    ShadowMatch matchesConstructorCall(Constructor aConstructor, Member withinCode);

    ShadowMatch matchesConstructorCall(Constructor aConstructor, Class callerType);

    ShadowMatch matchesHandler(Class exceptionType, Member withinCode);

    ShadowMatch matchesHandler(Class exceptionType, Class handlingType);

    ShadowMatch matchesFieldSet(Field aField, Member withinCode);

    ShadowMatch matchesFieldSet(Field aField, Class withinType);

    ShadowMatch matchesFieldGet(Field aField, Member withinCode);

    ShadowMatch matchesFieldGet(Field aField, Class withinType);

    String getPointcutExpression();
}
