package org.aspectj.weaver.tools;

import org.aspectj.weaver.WeaverMessages;

public class UnsupportedPointcutPrimitiveException extends RuntimeException {

    private static final long serialVersionUID = 3258689888517043251L;

    private PointcutPrimitive unsupportedPrimitive;

    private String pointcutExpression;

    public UnsupportedPointcutPrimitiveException(String pcExpression, PointcutPrimitive primitive) {
        super(WeaverMessages.format(WeaverMessages.UNSUPPORTED_POINTCUT_PRIMITIVE, pcExpression, primitive.getName()));
        this.pointcutExpression = pcExpression;
        this.unsupportedPrimitive = primitive;
    }

    public PointcutPrimitive getUnsupportedPrimitive() {
        return unsupportedPrimitive;
    }

    public String getInvalidPointcutExpression() {
        return pointcutExpression;
    }
}
