package org.aspectj.weaver.tools.cache;

import org.aspectj.weaver.tools.GeneratedClassHandler;

public class GeneratedCachedClassHandler implements GeneratedClassHandler {

    private final WeavedClassCache cache;

    private final GeneratedClassHandler nextGeneratedClassHandler;

    public GeneratedCachedClassHandler(WeavedClassCache cache, GeneratedClassHandler nextHandler) {
        this.cache = cache;
        this.nextGeneratedClassHandler = nextHandler;
    }

    public void acceptClass(String name, byte[] originalBytes, byte[] wovenBytes) {
        CachedClassReference ref = cache.createGeneratedCacheKey(name.replace('/', '.'));
        cache.put(ref, originalBytes, wovenBytes);
        if (nextGeneratedClassHandler != null) {
            nextGeneratedClassHandler.acceptClass(name, originalBytes, wovenBytes);
        }
    }
}
