package one.gfw.antlr4.sql.freemarker;

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public interface FreemarkerParserVisitor<T> extends ParseTreeVisitor<T> {

    T visitTemplate(FreemarkerParser.TemplateContext ctx);

    T visitElements(FreemarkerParser.ElementsContext ctx);

    T visitRawTextElement(FreemarkerParser.RawTextElementContext ctx);

    T visitDirectiveElement(FreemarkerParser.DirectiveElementContext ctx);

    T visitInlineExprElement(FreemarkerParser.InlineExprElementContext ctx);

    T visitRawText(FreemarkerParser.RawTextContext ctx);

    T visitDirective(FreemarkerParser.DirectiveContext ctx);

    T visitDirectiveIf(FreemarkerParser.DirectiveIfContext ctx);

    T visitDirectiveIfTrueElements(FreemarkerParser.DirectiveIfTrueElementsContext ctx);

    T visitDirectiveIfElseIfElements(FreemarkerParser.DirectiveIfElseIfElementsContext ctx);

    T visitDirectiveIfElseElements(FreemarkerParser.DirectiveIfElseElementsContext ctx);

    T visitTagExprElseIfs(FreemarkerParser.TagExprElseIfsContext ctx);

    T visitDirectiveAssign(FreemarkerParser.DirectiveAssignContext ctx);

    T visitDirectiveList(FreemarkerParser.DirectiveListContext ctx);

    T visitDirectiveListBodyElements(FreemarkerParser.DirectiveListBodyElementsContext ctx);

    T visitDirectiveListElseElements(FreemarkerParser.DirectiveListElseElementsContext ctx);

    T visitDirectiveInclude(FreemarkerParser.DirectiveIncludeContext ctx);

    T visitDirectiveImport(FreemarkerParser.DirectiveImportContext ctx);

    T visitDirectiveMacro(FreemarkerParser.DirectiveMacroContext ctx);

    T visitDirectiveNested(FreemarkerParser.DirectiveNestedContext ctx);

    T visitDirectiveReturn(FreemarkerParser.DirectiveReturnContext ctx);

    T visitDirectiveUser(FreemarkerParser.DirectiveUserContext ctx);

    T visitDirectiveUserId(FreemarkerParser.DirectiveUserIdContext ctx);

    T visitDirectiveUserParams(FreemarkerParser.DirectiveUserParamsContext ctx);

    T visitDirectiveUserLoopParams(FreemarkerParser.DirectiveUserLoopParamsContext ctx);

    T visitTagExpr(FreemarkerParser.TagExprContext ctx);

    T visitInlineExpr(FreemarkerParser.InlineExprContext ctx);

    T visitSingleQuote(FreemarkerParser.SingleQuoteContext ctx);

    T visitDoubleQuote(FreemarkerParser.DoubleQuoteContext ctx);

    T visitExprUnaryOp(FreemarkerParser.ExprUnaryOpContext ctx);

    T visitExprMulDivMod(FreemarkerParser.ExprMulDivModContext ctx);

    T visitBoolExpr(FreemarkerParser.BoolExprContext ctx);

    T visitStringExpr(FreemarkerParser.StringExprContext ctx);

    T visitExprBoolRelational(FreemarkerParser.ExprBoolRelationalContext ctx);

    T visitExprRoundParentheses(FreemarkerParser.ExprRoundParenthesesContext ctx);

    T visitExprBoolAnd(FreemarkerParser.ExprBoolAndContext ctx);

    T visitSymbolExpr(FreemarkerParser.SymbolExprContext ctx);

    T visitExprBuiltIn(FreemarkerParser.ExprBuiltInContext ctx);

    T visitStructExpr(FreemarkerParser.StructExprContext ctx);

    T visitExprMissingTest(FreemarkerParser.ExprMissingTestContext ctx);

    T visitExprAddSub(FreemarkerParser.ExprAddSubContext ctx);

    T visitExprDotAccess(FreemarkerParser.ExprDotAccessContext ctx);

    T visitExprBoolEq(FreemarkerParser.ExprBoolEqContext ctx);

    T visitExprFunctionCall(FreemarkerParser.ExprFunctionCallContext ctx);

    T visitNumberExpr(FreemarkerParser.NumberExprContext ctx);

    T visitExprDefault(FreemarkerParser.ExprDefaultContext ctx);

    T visitExprSquareParentheses(FreemarkerParser.ExprSquareParenthesesContext ctx);

    T visitExprBoolOr(FreemarkerParser.ExprBoolOrContext ctx);

    T visitFunctionParams(FreemarkerParser.FunctionParamsContext ctx);

    T visitBooleanRelationalOperator(FreemarkerParser.BooleanRelationalOperatorContext ctx);

    T visitStruct(FreemarkerParser.StructContext ctx);

    T visitStruct_pair(FreemarkerParser.Struct_pairContext ctx);

    T visitSingle_quote_string(FreemarkerParser.Single_quote_stringContext ctx);

    T visitDouble_quote_string(FreemarkerParser.Double_quote_stringContext ctx);
}
