/*
 * Decompiled with CFR 0.152.
 */
package one.gfw.antlr4.sql.postgresql;

import java.util.ArrayList;
import java.util.List;
import one.gfw.antlr4.sql.postgresql.PostgreSQLLexer;
import one.gfw.antlr4.sql.postgresql.PostgreSQLParseError;
import one.gfw.antlr4.sql.postgresql.PostgreSQLParser;
import one.gfw.antlr4.sql.postgresql.PostgreSQLParserErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class PostgreSQLParserBase
extends Parser {
    private PostgreSQLParserBase self;
    protected List<PostgreSQLParseError> ParseErrors = new ArrayList<PostgreSQLParseError>();

    public PostgreSQLParserBase(TokenStream input) {
        super(input);
        this.self = this;
    }

    ParserRuleContext GetParsedSqlTree(String script, int line) {
        PostgreSQLParser ph = PostgreSQLParserBase.getPostgreSQLParser(script);
        PostgreSQLParser.RootContext result = ph.root();
        for (PostgreSQLParseError err : ph.ParseErrors) {
            this.ParseErrors.add(new PostgreSQLParseError(err.getNumber(), err.getOffset(), err.getLine() + line, err.getColumn(), err.getMessage()));
        }
        return result;
    }

    public void ParseRoutineBody(PostgreSQLParser.Createfunc_opt_listContext _localctx) {
        String lang = null;
        for (Object coi : _localctx.createfunc_opt_item()) {
            if (coi.LANGUAGE() == null || coi.nonreservedword_or_sconst() == null || coi.nonreservedword_or_sconst().nonreservedword() == null || coi.nonreservedword_or_sconst().nonreservedword().identifier() == null || coi.nonreservedword_or_sconst().nonreservedword().identifier().Identifier() == null) continue;
            lang = coi.nonreservedword_or_sconst().nonreservedword().identifier().Identifier().getText();
            break;
        }
        if (null == lang) {
            return;
        }
        PostgreSQLParser.Createfunc_opt_itemContext func_as = null;
        for (PostgreSQLParser.Createfunc_opt_itemContext a : _localctx.createfunc_opt_item()) {
            if (a.func_as() == null) continue;
            func_as = a;
            break;
        }
        if (func_as != null) {
            String txt = PostgreSQLParserBase.GetRoutineBodyString(func_as.func_as().sconst(0));
            int line = func_as.func_as().sconst((int)0).start.getLine();
            PostgreSQLParser ph = PostgreSQLParserBase.getPostgreSQLParser(txt);
            switch (lang) {
                case "plpgsql": {
                    func_as.func_as().Definition = ph.plsqlroot();
                    break;
                }
                case "sql": {
                    func_as.func_as().Definition = ph.root();
                    break;
                }
            }
            for (PostgreSQLParseError err : ph.ParseErrors) {
                this.ParseErrors.add(new PostgreSQLParseError(err.getNumber(), err.getOffset(), err.getLine() + line, err.getColumn(), err.getMessage()));
            }
        }
    }

    private static String TrimQuotes(String s) {
        return s == null || s.isEmpty() ? "" : s.substring(1, s.length() - 2);
    }

    public static String unquote(String s) {
        int slength = s.length();
        StringBuilder r = new StringBuilder(slength);
        for (int i = 0; i < slength; ++i) {
            Character c = Character.valueOf(s.charAt(i));
            r.append(c);
            if (c.charValue() != '\'' || i >= slength - 1 || s.charAt(i + 1) != '\'') continue;
            ++i;
        }
        return r.toString();
    }

    public static String GetRoutineBodyString(PostgreSQLParser.SconstContext rule) {
        PostgreSQLParser.AnysconstContext anysconst = rule.anysconst();
        TerminalNode StringConstant = anysconst.StringConstant();
        if (null != StringConstant) {
            return PostgreSQLParserBase.unquote(PostgreSQLParserBase.TrimQuotes(StringConstant.getText()));
        }
        TerminalNode UnicodeEscapeStringConstant = anysconst.UnicodeEscapeStringConstant();
        if (null != UnicodeEscapeStringConstant) {
            return PostgreSQLParserBase.TrimQuotes(UnicodeEscapeStringConstant.getText());
        }
        TerminalNode EscapeStringConstant = anysconst.EscapeStringConstant();
        if (null != EscapeStringConstant) {
            return PostgreSQLParserBase.TrimQuotes(EscapeStringConstant.getText());
        }
        String result = "";
        List<TerminalNode> dollartext = anysconst.DollarText();
        for (TerminalNode s : dollartext) {
            result = result + s.getText();
        }
        return result;
    }

    public static PostgreSQLParser getPostgreSQLParser(String script) {
        CodePointCharStream charStream = CharStreams.fromString((String)script);
        PostgreSQLLexer lexer = new PostgreSQLLexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PostgreSQLParser parser = new PostgreSQLParser((TokenStream)tokens);
        PostgreSQLParserErrorListener errorListener = new PostgreSQLParserErrorListener();
        errorListener.grammar = parser;
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return parser;
    }
}

