package one.gfw.antlr4.js.javascript;

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public interface JavaScriptParserVisitor<T> extends ParseTreeVisitor<T> {

    T visitProgram(JavaScriptParser.ProgramContext ctx);

    T visitSourceElement(JavaScriptParser.SourceElementContext ctx);

    T visitStatement(JavaScriptParser.StatementContext ctx);

    T visitBlock(JavaScriptParser.BlockContext ctx);

    T visitStatementList(JavaScriptParser.StatementListContext ctx);

    T visitImportStatement(JavaScriptParser.ImportStatementContext ctx);

    T visitImportFromBlock(JavaScriptParser.ImportFromBlockContext ctx);

    T visitModuleItems(JavaScriptParser.ModuleItemsContext ctx);

    T visitImportDefault(JavaScriptParser.ImportDefaultContext ctx);

    T visitImportNamespace(JavaScriptParser.ImportNamespaceContext ctx);

    T visitImportFrom(JavaScriptParser.ImportFromContext ctx);

    T visitAliasName(JavaScriptParser.AliasNameContext ctx);

    T visitExportDeclaration(JavaScriptParser.ExportDeclarationContext ctx);

    T visitExportDefaultDeclaration(JavaScriptParser.ExportDefaultDeclarationContext ctx);

    T visitExportFromBlock(JavaScriptParser.ExportFromBlockContext ctx);

    T visitDeclaration(JavaScriptParser.DeclarationContext ctx);

    T visitVariableStatement(JavaScriptParser.VariableStatementContext ctx);

    T visitVariableDeclarationList(JavaScriptParser.VariableDeclarationListContext ctx);

    T visitVariableDeclaration(JavaScriptParser.VariableDeclarationContext ctx);

    T visitEmptyStatement_(JavaScriptParser.EmptyStatement_Context ctx);

    T visitExpressionStatement(JavaScriptParser.ExpressionStatementContext ctx);

    T visitIfStatement(JavaScriptParser.IfStatementContext ctx);

    T visitDoStatement(JavaScriptParser.DoStatementContext ctx);

    T visitWhileStatement(JavaScriptParser.WhileStatementContext ctx);

    T visitForStatement(JavaScriptParser.ForStatementContext ctx);

    T visitForInStatement(JavaScriptParser.ForInStatementContext ctx);

    T visitForOfStatement(JavaScriptParser.ForOfStatementContext ctx);

    T visitVarModifier(JavaScriptParser.VarModifierContext ctx);

    T visitContinueStatement(JavaScriptParser.ContinueStatementContext ctx);

    T visitBreakStatement(JavaScriptParser.BreakStatementContext ctx);

    T visitReturnStatement(JavaScriptParser.ReturnStatementContext ctx);

    T visitYieldStatement(JavaScriptParser.YieldStatementContext ctx);

    T visitWithStatement(JavaScriptParser.WithStatementContext ctx);

    T visitSwitchStatement(JavaScriptParser.SwitchStatementContext ctx);

    T visitCaseBlock(JavaScriptParser.CaseBlockContext ctx);

    T visitCaseClauses(JavaScriptParser.CaseClausesContext ctx);

    T visitCaseClause(JavaScriptParser.CaseClauseContext ctx);

    T visitDefaultClause(JavaScriptParser.DefaultClauseContext ctx);

    T visitLabelledStatement(JavaScriptParser.LabelledStatementContext ctx);

    T visitThrowStatement(JavaScriptParser.ThrowStatementContext ctx);

    T visitTryStatement(JavaScriptParser.TryStatementContext ctx);

    T visitCatchProduction(JavaScriptParser.CatchProductionContext ctx);

    T visitFinallyProduction(JavaScriptParser.FinallyProductionContext ctx);

    T visitDebuggerStatement(JavaScriptParser.DebuggerStatementContext ctx);

    T visitFunctionDeclaration(JavaScriptParser.FunctionDeclarationContext ctx);

    T visitClassDeclaration(JavaScriptParser.ClassDeclarationContext ctx);

    T visitClassTail(JavaScriptParser.ClassTailContext ctx);

    T visitClassElement(JavaScriptParser.ClassElementContext ctx);

    T visitMethodDefinition(JavaScriptParser.MethodDefinitionContext ctx);

    T visitFormalParameterList(JavaScriptParser.FormalParameterListContext ctx);

    T visitFormalParameterArg(JavaScriptParser.FormalParameterArgContext ctx);

    T visitLastFormalParameterArg(JavaScriptParser.LastFormalParameterArgContext ctx);

    T visitFunctionBody(JavaScriptParser.FunctionBodyContext ctx);

    T visitSourceElements(JavaScriptParser.SourceElementsContext ctx);

    T visitArrayLiteral(JavaScriptParser.ArrayLiteralContext ctx);

    T visitElementList(JavaScriptParser.ElementListContext ctx);

    T visitArrayElement(JavaScriptParser.ArrayElementContext ctx);

    T visitPropertyExpressionAssignment(JavaScriptParser.PropertyExpressionAssignmentContext ctx);

    T visitComputedPropertyExpressionAssignment(JavaScriptParser.ComputedPropertyExpressionAssignmentContext ctx);

    T visitFunctionProperty(JavaScriptParser.FunctionPropertyContext ctx);

    T visitPropertyGetter(JavaScriptParser.PropertyGetterContext ctx);

    T visitPropertySetter(JavaScriptParser.PropertySetterContext ctx);

    T visitPropertyShorthand(JavaScriptParser.PropertyShorthandContext ctx);

    T visitPropertyName(JavaScriptParser.PropertyNameContext ctx);

    T visitArguments(JavaScriptParser.ArgumentsContext ctx);

    T visitArgument(JavaScriptParser.ArgumentContext ctx);

    T visitExpressionSequence(JavaScriptParser.ExpressionSequenceContext ctx);

    T visitTemplateStringExpression(JavaScriptParser.TemplateStringExpressionContext ctx);

    T visitTernaryExpression(JavaScriptParser.TernaryExpressionContext ctx);

    T visitLogicalAndExpression(JavaScriptParser.LogicalAndExpressionContext ctx);

    T visitPowerExpression(JavaScriptParser.PowerExpressionContext ctx);

    T visitPreIncrementExpression(JavaScriptParser.PreIncrementExpressionContext ctx);

    T visitObjectLiteralExpression(JavaScriptParser.ObjectLiteralExpressionContext ctx);

    T visitMetaExpression(JavaScriptParser.MetaExpressionContext ctx);

    T visitInExpression(JavaScriptParser.InExpressionContext ctx);

    T visitLogicalOrExpression(JavaScriptParser.LogicalOrExpressionContext ctx);

    T visitNotExpression(JavaScriptParser.NotExpressionContext ctx);

    T visitPreDecreaseExpression(JavaScriptParser.PreDecreaseExpressionContext ctx);

    T visitArgumentsExpression(JavaScriptParser.ArgumentsExpressionContext ctx);

    T visitAwaitExpression(JavaScriptParser.AwaitExpressionContext ctx);

    T visitThisExpression(JavaScriptParser.ThisExpressionContext ctx);

    T visitFunctionExpression(JavaScriptParser.FunctionExpressionContext ctx);

    T visitUnaryMinusExpression(JavaScriptParser.UnaryMinusExpressionContext ctx);

    T visitAssignmentExpression(JavaScriptParser.AssignmentExpressionContext ctx);

    T visitPostDecreaseExpression(JavaScriptParser.PostDecreaseExpressionContext ctx);

    T visitTypeofExpression(JavaScriptParser.TypeofExpressionContext ctx);

    T visitInstanceofExpression(JavaScriptParser.InstanceofExpressionContext ctx);

    T visitUnaryPlusExpression(JavaScriptParser.UnaryPlusExpressionContext ctx);

    T visitDeleteExpression(JavaScriptParser.DeleteExpressionContext ctx);

    T visitImportExpression(JavaScriptParser.ImportExpressionContext ctx);

    T visitEqualityExpression(JavaScriptParser.EqualityExpressionContext ctx);

    T visitBitXOrExpression(JavaScriptParser.BitXOrExpressionContext ctx);

    T visitSuperExpression(JavaScriptParser.SuperExpressionContext ctx);

    T visitMultiplicativeExpression(JavaScriptParser.MultiplicativeExpressionContext ctx);

    T visitBitShiftExpression(JavaScriptParser.BitShiftExpressionContext ctx);

    T visitParenthesizedExpression(JavaScriptParser.ParenthesizedExpressionContext ctx);

    T visitAdditiveExpression(JavaScriptParser.AdditiveExpressionContext ctx);

    T visitRelationalExpression(JavaScriptParser.RelationalExpressionContext ctx);

    T visitPostIncrementExpression(JavaScriptParser.PostIncrementExpressionContext ctx);

    T visitYieldExpression(JavaScriptParser.YieldExpressionContext ctx);

    T visitBitNotExpression(JavaScriptParser.BitNotExpressionContext ctx);

    T visitNewExpression(JavaScriptParser.NewExpressionContext ctx);

    T visitLiteralExpression(JavaScriptParser.LiteralExpressionContext ctx);

    T visitArrayLiteralExpression(JavaScriptParser.ArrayLiteralExpressionContext ctx);

    T visitMemberDotExpression(JavaScriptParser.MemberDotExpressionContext ctx);

    T visitClassExpression(JavaScriptParser.ClassExpressionContext ctx);

    T visitMemberIndexExpression(JavaScriptParser.MemberIndexExpressionContext ctx);

    T visitIdentifierExpression(JavaScriptParser.IdentifierExpressionContext ctx);

    T visitBitAndExpression(JavaScriptParser.BitAndExpressionContext ctx);

    T visitBitOrExpression(JavaScriptParser.BitOrExpressionContext ctx);

    T visitAssignmentOperatorExpression(JavaScriptParser.AssignmentOperatorExpressionContext ctx);

    T visitVoidExpression(JavaScriptParser.VoidExpressionContext ctx);

    T visitCoalesceExpression(JavaScriptParser.CoalesceExpressionContext ctx);

    T visitAssignable(JavaScriptParser.AssignableContext ctx);

    T visitObjectLiteral(JavaScriptParser.ObjectLiteralContext ctx);

    T visitFunctionDecl(JavaScriptParser.FunctionDeclContext ctx);

    T visitAnonymousFunctionDecl(JavaScriptParser.AnonymousFunctionDeclContext ctx);

    T visitArrowFunction(JavaScriptParser.ArrowFunctionContext ctx);

    T visitArrowFunctionParameters(JavaScriptParser.ArrowFunctionParametersContext ctx);

    T visitArrowFunctionBody(JavaScriptParser.ArrowFunctionBodyContext ctx);

    T visitAssignmentOperator(JavaScriptParser.AssignmentOperatorContext ctx);

    T visitLiteral(JavaScriptParser.LiteralContext ctx);

    T visitTemplateStringLiteral(JavaScriptParser.TemplateStringLiteralContext ctx);

    T visitTemplateStringAtom(JavaScriptParser.TemplateStringAtomContext ctx);

    T visitNumericLiteral(JavaScriptParser.NumericLiteralContext ctx);

    T visitBigintLiteral(JavaScriptParser.BigintLiteralContext ctx);

    T visitGetter(JavaScriptParser.GetterContext ctx);

    T visitSetter(JavaScriptParser.SetterContext ctx);

    T visitIdentifierName(JavaScriptParser.IdentifierNameContext ctx);

    T visitIdentifier(JavaScriptParser.IdentifierContext ctx);

    T visitReservedWord(JavaScriptParser.ReservedWordContext ctx);

    T visitKeyword(JavaScriptParser.KeywordContext ctx);

    T visitLet_(JavaScriptParser.Let_Context ctx);

    T visitEos(JavaScriptParser.EosContext ctx);
}
