package one.gfw.antlr4.js.typescript;

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public interface TypeScriptParserVisitor<T> extends ParseTreeVisitor<T> {

    T visitInitializer(TypeScriptParser.InitializerContext ctx);

    T visitBindingPattern(TypeScriptParser.BindingPatternContext ctx);

    T visitTypeParameters(TypeScriptParser.TypeParametersContext ctx);

    T visitTypeParameterList(TypeScriptParser.TypeParameterListContext ctx);

    T visitTypeParameter(TypeScriptParser.TypeParameterContext ctx);

    T visitConstraint(TypeScriptParser.ConstraintContext ctx);

    T visitTypeArguments(TypeScriptParser.TypeArgumentsContext ctx);

    T visitTypeArgumentList(TypeScriptParser.TypeArgumentListContext ctx);

    T visitTypeArgument(TypeScriptParser.TypeArgumentContext ctx);

    T visitType_(TypeScriptParser.Type_Context ctx);

    T visitIntersection(TypeScriptParser.IntersectionContext ctx);

    T visitPrimary(TypeScriptParser.PrimaryContext ctx);

    T visitUnion(TypeScriptParser.UnionContext ctx);

    T visitRedefinitionOfType(TypeScriptParser.RedefinitionOfTypeContext ctx);

    T visitPredefinedPrimType(TypeScriptParser.PredefinedPrimTypeContext ctx);

    T visitArrayPrimType(TypeScriptParser.ArrayPrimTypeContext ctx);

    T visitParenthesizedPrimType(TypeScriptParser.ParenthesizedPrimTypeContext ctx);

    T visitThisPrimType(TypeScriptParser.ThisPrimTypeContext ctx);

    T visitTuplePrimType(TypeScriptParser.TuplePrimTypeContext ctx);

    T visitObjectPrimType(TypeScriptParser.ObjectPrimTypeContext ctx);

    T visitReferencePrimType(TypeScriptParser.ReferencePrimTypeContext ctx);

    T visitQueryPrimType(TypeScriptParser.QueryPrimTypeContext ctx);

    T visitPredefinedType(TypeScriptParser.PredefinedTypeContext ctx);

    T visitTypeReference(TypeScriptParser.TypeReferenceContext ctx);

    T visitNestedTypeGeneric(TypeScriptParser.NestedTypeGenericContext ctx);

    T visitTypeGeneric(TypeScriptParser.TypeGenericContext ctx);

    T visitTypeIncludeGeneric(TypeScriptParser.TypeIncludeGenericContext ctx);

    T visitTypeName(TypeScriptParser.TypeNameContext ctx);

    T visitObjectType(TypeScriptParser.ObjectTypeContext ctx);

    T visitTypeBody(TypeScriptParser.TypeBodyContext ctx);

    T visitTypeMemberList(TypeScriptParser.TypeMemberListContext ctx);

    T visitTypeMember(TypeScriptParser.TypeMemberContext ctx);

    T visitArrayType(TypeScriptParser.ArrayTypeContext ctx);

    T visitTupleType(TypeScriptParser.TupleTypeContext ctx);

    T visitTupleElementTypes(TypeScriptParser.TupleElementTypesContext ctx);

    T visitFunctionType(TypeScriptParser.FunctionTypeContext ctx);

    T visitConstructorType(TypeScriptParser.ConstructorTypeContext ctx);

    T visitTypeQuery(TypeScriptParser.TypeQueryContext ctx);

    T visitTypeQueryExpression(TypeScriptParser.TypeQueryExpressionContext ctx);

    T visitPropertySignatur(TypeScriptParser.PropertySignaturContext ctx);

    T visitTypeAnnotation(TypeScriptParser.TypeAnnotationContext ctx);

    T visitCallSignature(TypeScriptParser.CallSignatureContext ctx);

    T visitParameterList(TypeScriptParser.ParameterListContext ctx);

    T visitRequiredParameterList(TypeScriptParser.RequiredParameterListContext ctx);

    T visitParameter(TypeScriptParser.ParameterContext ctx);

    T visitOptionalParameter(TypeScriptParser.OptionalParameterContext ctx);

    T visitRestParameter(TypeScriptParser.RestParameterContext ctx);

    T visitRequiredParameter(TypeScriptParser.RequiredParameterContext ctx);

    T visitAccessibilityModifier(TypeScriptParser.AccessibilityModifierContext ctx);

    T visitIdentifierOrPattern(TypeScriptParser.IdentifierOrPatternContext ctx);

    T visitConstructSignature(TypeScriptParser.ConstructSignatureContext ctx);

    T visitIndexSignature(TypeScriptParser.IndexSignatureContext ctx);

    T visitMethodSignature(TypeScriptParser.MethodSignatureContext ctx);

    T visitTypeAliasDeclaration(TypeScriptParser.TypeAliasDeclarationContext ctx);

    T visitConstructorDeclaration(TypeScriptParser.ConstructorDeclarationContext ctx);

    T visitInterfaceDeclaration(TypeScriptParser.InterfaceDeclarationContext ctx);

    T visitInterfaceExtendsClause(TypeScriptParser.InterfaceExtendsClauseContext ctx);

    T visitClassOrInterfaceTypeList(TypeScriptParser.ClassOrInterfaceTypeListContext ctx);

    T visitEnumDeclaration(TypeScriptParser.EnumDeclarationContext ctx);

    T visitEnumBody(TypeScriptParser.EnumBodyContext ctx);

    T visitEnumMemberList(TypeScriptParser.EnumMemberListContext ctx);

    T visitEnumMember(TypeScriptParser.EnumMemberContext ctx);

    T visitNamespaceDeclaration(TypeScriptParser.NamespaceDeclarationContext ctx);

    T visitNamespaceName(TypeScriptParser.NamespaceNameContext ctx);

    T visitImportAliasDeclaration(TypeScriptParser.ImportAliasDeclarationContext ctx);

    T visitDecoratorList(TypeScriptParser.DecoratorListContext ctx);

    T visitDecorator(TypeScriptParser.DecoratorContext ctx);

    T visitDecoratorMemberExpression(TypeScriptParser.DecoratorMemberExpressionContext ctx);

    T visitDecoratorCallExpression(TypeScriptParser.DecoratorCallExpressionContext ctx);

    T visitProgram(TypeScriptParser.ProgramContext ctx);

    T visitSourceElement(TypeScriptParser.SourceElementContext ctx);

    T visitStatement(TypeScriptParser.StatementContext ctx);

    T visitBlock(TypeScriptParser.BlockContext ctx);

    T visitStatementList(TypeScriptParser.StatementListContext ctx);

    T visitAbstractDeclaration(TypeScriptParser.AbstractDeclarationContext ctx);

    T visitImportStatement(TypeScriptParser.ImportStatementContext ctx);

    T visitFromBlock(TypeScriptParser.FromBlockContext ctx);

    T visitMultipleImportStatement(TypeScriptParser.MultipleImportStatementContext ctx);

    T visitExportStatement(TypeScriptParser.ExportStatementContext ctx);

    T visitVariableStatement(TypeScriptParser.VariableStatementContext ctx);

    T visitVariableDeclarationList(TypeScriptParser.VariableDeclarationListContext ctx);

    T visitVariableDeclaration(TypeScriptParser.VariableDeclarationContext ctx);

    T visitEmptyStatement_(TypeScriptParser.EmptyStatement_Context ctx);

    T visitExpressionStatement(TypeScriptParser.ExpressionStatementContext ctx);

    T visitIfStatement(TypeScriptParser.IfStatementContext ctx);

    T visitDoStatement(TypeScriptParser.DoStatementContext ctx);

    T visitWhileStatement(TypeScriptParser.WhileStatementContext ctx);

    T visitForStatement(TypeScriptParser.ForStatementContext ctx);

    T visitForVarStatement(TypeScriptParser.ForVarStatementContext ctx);

    T visitForInStatement(TypeScriptParser.ForInStatementContext ctx);

    T visitForVarInStatement(TypeScriptParser.ForVarInStatementContext ctx);

    T visitVarModifier(TypeScriptParser.VarModifierContext ctx);

    T visitContinueStatement(TypeScriptParser.ContinueStatementContext ctx);

    T visitBreakStatement(TypeScriptParser.BreakStatementContext ctx);

    T visitReturnStatement(TypeScriptParser.ReturnStatementContext ctx);

    T visitYieldStatement(TypeScriptParser.YieldStatementContext ctx);

    T visitWithStatement(TypeScriptParser.WithStatementContext ctx);

    T visitSwitchStatement(TypeScriptParser.SwitchStatementContext ctx);

    T visitCaseBlock(TypeScriptParser.CaseBlockContext ctx);

    T visitCaseClauses(TypeScriptParser.CaseClausesContext ctx);

    T visitCaseClause(TypeScriptParser.CaseClauseContext ctx);

    T visitDefaultClause(TypeScriptParser.DefaultClauseContext ctx);

    T visitLabelledStatement(TypeScriptParser.LabelledStatementContext ctx);

    T visitThrowStatement(TypeScriptParser.ThrowStatementContext ctx);

    T visitTryStatement(TypeScriptParser.TryStatementContext ctx);

    T visitCatchProduction(TypeScriptParser.CatchProductionContext ctx);

    T visitFinallyProduction(TypeScriptParser.FinallyProductionContext ctx);

    T visitDebuggerStatement(TypeScriptParser.DebuggerStatementContext ctx);

    T visitFunctionDeclaration(TypeScriptParser.FunctionDeclarationContext ctx);

    T visitClassDeclaration(TypeScriptParser.ClassDeclarationContext ctx);

    T visitClassHeritage(TypeScriptParser.ClassHeritageContext ctx);

    T visitClassTail(TypeScriptParser.ClassTailContext ctx);

    T visitClassExtendsClause(TypeScriptParser.ClassExtendsClauseContext ctx);

    T visitImplementsClause(TypeScriptParser.ImplementsClauseContext ctx);

    T visitClassElement(TypeScriptParser.ClassElementContext ctx);

    T visitPropertyDeclarationExpression(TypeScriptParser.PropertyDeclarationExpressionContext ctx);

    T visitMethodDeclarationExpression(TypeScriptParser.MethodDeclarationExpressionContext ctx);

    T visitGetterSetterDeclarationExpression(TypeScriptParser.GetterSetterDeclarationExpressionContext ctx);

    T visitAbstractMemberDeclaration(TypeScriptParser.AbstractMemberDeclarationContext ctx);

    T visitPropertyMemberBase(TypeScriptParser.PropertyMemberBaseContext ctx);

    T visitIndexMemberDeclaration(TypeScriptParser.IndexMemberDeclarationContext ctx);

    T visitGeneratorMethod(TypeScriptParser.GeneratorMethodContext ctx);

    T visitGeneratorFunctionDeclaration(TypeScriptParser.GeneratorFunctionDeclarationContext ctx);

    T visitGeneratorBlock(TypeScriptParser.GeneratorBlockContext ctx);

    T visitGeneratorDefinition(TypeScriptParser.GeneratorDefinitionContext ctx);

    T visitIteratorBlock(TypeScriptParser.IteratorBlockContext ctx);

    T visitIteratorDefinition(TypeScriptParser.IteratorDefinitionContext ctx);

    T visitFormalParameterList(TypeScriptParser.FormalParameterListContext ctx);

    T visitFormalParameterArg(TypeScriptParser.FormalParameterArgContext ctx);

    T visitLastFormalParameterArg(TypeScriptParser.LastFormalParameterArgContext ctx);

    T visitFunctionBody(TypeScriptParser.FunctionBodyContext ctx);

    T visitSourceElements(TypeScriptParser.SourceElementsContext ctx);

    T visitArrayLiteral(TypeScriptParser.ArrayLiteralContext ctx);

    T visitElementList(TypeScriptParser.ElementListContext ctx);

    T visitArrayElement(TypeScriptParser.ArrayElementContext ctx);

    T visitObjectLiteral(TypeScriptParser.ObjectLiteralContext ctx);

    T visitPropertyExpressionAssignment(TypeScriptParser.PropertyExpressionAssignmentContext ctx);

    T visitComputedPropertyExpressionAssignment(TypeScriptParser.ComputedPropertyExpressionAssignmentContext ctx);

    T visitPropertyGetter(TypeScriptParser.PropertyGetterContext ctx);

    T visitPropertySetter(TypeScriptParser.PropertySetterContext ctx);

    T visitMethodProperty(TypeScriptParser.MethodPropertyContext ctx);

    T visitPropertyShorthand(TypeScriptParser.PropertyShorthandContext ctx);

    T visitRestParameterInObject(TypeScriptParser.RestParameterInObjectContext ctx);

    T visitGetAccessor(TypeScriptParser.GetAccessorContext ctx);

    T visitSetAccessor(TypeScriptParser.SetAccessorContext ctx);

    T visitPropertyName(TypeScriptParser.PropertyNameContext ctx);

    T visitArguments(TypeScriptParser.ArgumentsContext ctx);

    T visitArgumentList(TypeScriptParser.ArgumentListContext ctx);

    T visitArgument(TypeScriptParser.ArgumentContext ctx);

    T visitExpressionSequence(TypeScriptParser.ExpressionSequenceContext ctx);

    T visitFunctionExpressionDeclaration(TypeScriptParser.FunctionExpressionDeclarationContext ctx);

    T visitTemplateStringExpression(TypeScriptParser.TemplateStringExpressionContext ctx);

    T visitTernaryExpression(TypeScriptParser.TernaryExpressionContext ctx);

    T visitLogicalAndExpression(TypeScriptParser.LogicalAndExpressionContext ctx);

    T visitGeneratorsExpression(TypeScriptParser.GeneratorsExpressionContext ctx);

    T visitPreIncrementExpression(TypeScriptParser.PreIncrementExpressionContext ctx);

    T visitObjectLiteralExpression(TypeScriptParser.ObjectLiteralExpressionContext ctx);

    T visitInExpression(TypeScriptParser.InExpressionContext ctx);

    T visitLogicalOrExpression(TypeScriptParser.LogicalOrExpressionContext ctx);

    T visitGenericTypes(TypeScriptParser.GenericTypesContext ctx);

    T visitNotExpression(TypeScriptParser.NotExpressionContext ctx);

    T visitPreDecreaseExpression(TypeScriptParser.PreDecreaseExpressionContext ctx);

    T visitArgumentsExpression(TypeScriptParser.ArgumentsExpressionContext ctx);

    T visitThisExpression(TypeScriptParser.ThisExpressionContext ctx);

    T visitFunctionExpression(TypeScriptParser.FunctionExpressionContext ctx);

    T visitUnaryMinusExpression(TypeScriptParser.UnaryMinusExpressionContext ctx);

    T visitAssignmentExpression(TypeScriptParser.AssignmentExpressionContext ctx);

    T visitPostDecreaseExpression(TypeScriptParser.PostDecreaseExpressionContext ctx);

    T visitTypeofExpression(TypeScriptParser.TypeofExpressionContext ctx);

    T visitInstanceofExpression(TypeScriptParser.InstanceofExpressionContext ctx);

    T visitUnaryPlusExpression(TypeScriptParser.UnaryPlusExpressionContext ctx);

    T visitDeleteExpression(TypeScriptParser.DeleteExpressionContext ctx);

    T visitGeneratorsFunctionExpression(TypeScriptParser.GeneratorsFunctionExpressionContext ctx);

    T visitArrowFunctionExpression(TypeScriptParser.ArrowFunctionExpressionContext ctx);

    T visitIteratorsExpression(TypeScriptParser.IteratorsExpressionContext ctx);

    T visitEqualityExpression(TypeScriptParser.EqualityExpressionContext ctx);

    T visitBitXOrExpression(TypeScriptParser.BitXOrExpressionContext ctx);

    T visitCastAsExpression(TypeScriptParser.CastAsExpressionContext ctx);

    T visitSuperExpression(TypeScriptParser.SuperExpressionContext ctx);

    T visitMultiplicativeExpression(TypeScriptParser.MultiplicativeExpressionContext ctx);

    T visitBitShiftExpression(TypeScriptParser.BitShiftExpressionContext ctx);

    T visitParenthesizedExpression(TypeScriptParser.ParenthesizedExpressionContext ctx);

    T visitAdditiveExpression(TypeScriptParser.AdditiveExpressionContext ctx);

    T visitRelationalExpression(TypeScriptParser.RelationalExpressionContext ctx);

    T visitPostIncrementExpression(TypeScriptParser.PostIncrementExpressionContext ctx);

    T visitYieldExpression(TypeScriptParser.YieldExpressionContext ctx);

    T visitBitNotExpression(TypeScriptParser.BitNotExpressionContext ctx);

    T visitNewExpression(TypeScriptParser.NewExpressionContext ctx);

    T visitLiteralExpression(TypeScriptParser.LiteralExpressionContext ctx);

    T visitArrayLiteralExpression(TypeScriptParser.ArrayLiteralExpressionContext ctx);

    T visitMemberDotExpression(TypeScriptParser.MemberDotExpressionContext ctx);

    T visitClassExpression(TypeScriptParser.ClassExpressionContext ctx);

    T visitMemberIndexExpression(TypeScriptParser.MemberIndexExpressionContext ctx);

    T visitIdentifierExpression(TypeScriptParser.IdentifierExpressionContext ctx);

    T visitBitAndExpression(TypeScriptParser.BitAndExpressionContext ctx);

    T visitBitOrExpression(TypeScriptParser.BitOrExpressionContext ctx);

    T visitAssignmentOperatorExpression(TypeScriptParser.AssignmentOperatorExpressionContext ctx);

    T visitVoidExpression(TypeScriptParser.VoidExpressionContext ctx);

    T visitAsExpression(TypeScriptParser.AsExpressionContext ctx);

    T visitArrowFunctionDeclaration(TypeScriptParser.ArrowFunctionDeclarationContext ctx);

    T visitArrowFunctionParameters(TypeScriptParser.ArrowFunctionParametersContext ctx);

    T visitArrowFunctionBody(TypeScriptParser.ArrowFunctionBodyContext ctx);

    T visitAssignmentOperator(TypeScriptParser.AssignmentOperatorContext ctx);

    T visitLiteral(TypeScriptParser.LiteralContext ctx);

    T visitTemplateStringLiteral(TypeScriptParser.TemplateStringLiteralContext ctx);

    T visitTemplateStringAtom(TypeScriptParser.TemplateStringAtomContext ctx);

    T visitNumericLiteral(TypeScriptParser.NumericLiteralContext ctx);

    T visitIdentifierName(TypeScriptParser.IdentifierNameContext ctx);

    T visitIdentifierOrKeyWord(TypeScriptParser.IdentifierOrKeyWordContext ctx);

    T visitReservedWord(TypeScriptParser.ReservedWordContext ctx);

    T visitKeyword(TypeScriptParser.KeywordContext ctx);

    T visitGetter(TypeScriptParser.GetterContext ctx);

    T visitSetter(TypeScriptParser.SetterContext ctx);

    T visitEos(TypeScriptParser.EosContext ctx);
}
