package one.gfw.antlr4.sql.freemarker;

import org.antlr.v4.runtime.tree.ParseTreeListener;

public interface FreemarkerParserListener extends ParseTreeListener {

    void enterTemplate(FreemarkerParser.TemplateContext ctx);

    void exitTemplate(FreemarkerParser.TemplateContext ctx);

    void enterElements(FreemarkerParser.ElementsContext ctx);

    void exitElements(FreemarkerParser.ElementsContext ctx);

    void enterRawTextElement(FreemarkerParser.RawTextElementContext ctx);

    void exitRawTextElement(FreemarkerParser.RawTextElementContext ctx);

    void enterDirectiveElement(FreemarkerParser.DirectiveElementContext ctx);

    void exitDirectiveElement(FreemarkerParser.DirectiveElementContext ctx);

    void enterInlineExprElement(FreemarkerParser.InlineExprElementContext ctx);

    void exitInlineExprElement(FreemarkerParser.InlineExprElementContext ctx);

    void enterRawText(FreemarkerParser.RawTextContext ctx);

    void exitRawText(FreemarkerParser.RawTextContext ctx);

    void enterDirective(FreemarkerParser.DirectiveContext ctx);

    void exitDirective(FreemarkerParser.DirectiveContext ctx);

    void enterDirectiveIf(FreemarkerParser.DirectiveIfContext ctx);

    void exitDirectiveIf(FreemarkerParser.DirectiveIfContext ctx);

    void enterDirectiveIfTrueElements(FreemarkerParser.DirectiveIfTrueElementsContext ctx);

    void exitDirectiveIfTrueElements(FreemarkerParser.DirectiveIfTrueElementsContext ctx);

    void enterDirectiveIfElseIfElements(FreemarkerParser.DirectiveIfElseIfElementsContext ctx);

    void exitDirectiveIfElseIfElements(FreemarkerParser.DirectiveIfElseIfElementsContext ctx);

    void enterDirectiveIfElseElements(FreemarkerParser.DirectiveIfElseElementsContext ctx);

    void exitDirectiveIfElseElements(FreemarkerParser.DirectiveIfElseElementsContext ctx);

    void enterTagExprElseIfs(FreemarkerParser.TagExprElseIfsContext ctx);

    void exitTagExprElseIfs(FreemarkerParser.TagExprElseIfsContext ctx);

    void enterDirectiveAssign(FreemarkerParser.DirectiveAssignContext ctx);

    void exitDirectiveAssign(FreemarkerParser.DirectiveAssignContext ctx);

    void enterDirectiveList(FreemarkerParser.DirectiveListContext ctx);

    void exitDirectiveList(FreemarkerParser.DirectiveListContext ctx);

    void enterDirectiveListBodyElements(FreemarkerParser.DirectiveListBodyElementsContext ctx);

    void exitDirectiveListBodyElements(FreemarkerParser.DirectiveListBodyElementsContext ctx);

    void enterDirectiveListElseElements(FreemarkerParser.DirectiveListElseElementsContext ctx);

    void exitDirectiveListElseElements(FreemarkerParser.DirectiveListElseElementsContext ctx);

    void enterDirectiveInclude(FreemarkerParser.DirectiveIncludeContext ctx);

    void exitDirectiveInclude(FreemarkerParser.DirectiveIncludeContext ctx);

    void enterDirectiveImport(FreemarkerParser.DirectiveImportContext ctx);

    void exitDirectiveImport(FreemarkerParser.DirectiveImportContext ctx);

    void enterDirectiveMacro(FreemarkerParser.DirectiveMacroContext ctx);

    void exitDirectiveMacro(FreemarkerParser.DirectiveMacroContext ctx);

    void enterDirectiveNested(FreemarkerParser.DirectiveNestedContext ctx);

    void exitDirectiveNested(FreemarkerParser.DirectiveNestedContext ctx);

    void enterDirectiveReturn(FreemarkerParser.DirectiveReturnContext ctx);

    void exitDirectiveReturn(FreemarkerParser.DirectiveReturnContext ctx);

    void enterDirectiveUser(FreemarkerParser.DirectiveUserContext ctx);

    void exitDirectiveUser(FreemarkerParser.DirectiveUserContext ctx);

    void enterDirectiveUserId(FreemarkerParser.DirectiveUserIdContext ctx);

    void exitDirectiveUserId(FreemarkerParser.DirectiveUserIdContext ctx);

    void enterDirectiveUserParams(FreemarkerParser.DirectiveUserParamsContext ctx);

    void exitDirectiveUserParams(FreemarkerParser.DirectiveUserParamsContext ctx);

    void enterDirectiveUserLoopParams(FreemarkerParser.DirectiveUserLoopParamsContext ctx);

    void exitDirectiveUserLoopParams(FreemarkerParser.DirectiveUserLoopParamsContext ctx);

    void enterTagExpr(FreemarkerParser.TagExprContext ctx);

    void exitTagExpr(FreemarkerParser.TagExprContext ctx);

    void enterInlineExpr(FreemarkerParser.InlineExprContext ctx);

    void exitInlineExpr(FreemarkerParser.InlineExprContext ctx);

    void enterSingleQuote(FreemarkerParser.SingleQuoteContext ctx);

    void exitSingleQuote(FreemarkerParser.SingleQuoteContext ctx);

    void enterDoubleQuote(FreemarkerParser.DoubleQuoteContext ctx);

    void exitDoubleQuote(FreemarkerParser.DoubleQuoteContext ctx);

    void enterExprUnaryOp(FreemarkerParser.ExprUnaryOpContext ctx);

    void exitExprUnaryOp(FreemarkerParser.ExprUnaryOpContext ctx);

    void enterExprMulDivMod(FreemarkerParser.ExprMulDivModContext ctx);

    void exitExprMulDivMod(FreemarkerParser.ExprMulDivModContext ctx);

    void enterBoolExpr(FreemarkerParser.BoolExprContext ctx);

    void exitBoolExpr(FreemarkerParser.BoolExprContext ctx);

    void enterStringExpr(FreemarkerParser.StringExprContext ctx);

    void exitStringExpr(FreemarkerParser.StringExprContext ctx);

    void enterExprBoolRelational(FreemarkerParser.ExprBoolRelationalContext ctx);

    void exitExprBoolRelational(FreemarkerParser.ExprBoolRelationalContext ctx);

    void enterExprRoundParentheses(FreemarkerParser.ExprRoundParenthesesContext ctx);

    void exitExprRoundParentheses(FreemarkerParser.ExprRoundParenthesesContext ctx);

    void enterExprBoolAnd(FreemarkerParser.ExprBoolAndContext ctx);

    void exitExprBoolAnd(FreemarkerParser.ExprBoolAndContext ctx);

    void enterSymbolExpr(FreemarkerParser.SymbolExprContext ctx);

    void exitSymbolExpr(FreemarkerParser.SymbolExprContext ctx);

    void enterExprBuiltIn(FreemarkerParser.ExprBuiltInContext ctx);

    void exitExprBuiltIn(FreemarkerParser.ExprBuiltInContext ctx);

    void enterStructExpr(FreemarkerParser.StructExprContext ctx);

    void exitStructExpr(FreemarkerParser.StructExprContext ctx);

    void enterExprMissingTest(FreemarkerParser.ExprMissingTestContext ctx);

    void exitExprMissingTest(FreemarkerParser.ExprMissingTestContext ctx);

    void enterExprAddSub(FreemarkerParser.ExprAddSubContext ctx);

    void exitExprAddSub(FreemarkerParser.ExprAddSubContext ctx);

    void enterExprDotAccess(FreemarkerParser.ExprDotAccessContext ctx);

    void exitExprDotAccess(FreemarkerParser.ExprDotAccessContext ctx);

    void enterExprBoolEq(FreemarkerParser.ExprBoolEqContext ctx);

    void exitExprBoolEq(FreemarkerParser.ExprBoolEqContext ctx);

    void enterExprFunctionCall(FreemarkerParser.ExprFunctionCallContext ctx);

    void exitExprFunctionCall(FreemarkerParser.ExprFunctionCallContext ctx);

    void enterNumberExpr(FreemarkerParser.NumberExprContext ctx);

    void exitNumberExpr(FreemarkerParser.NumberExprContext ctx);

    void enterExprDefault(FreemarkerParser.ExprDefaultContext ctx);

    void exitExprDefault(FreemarkerParser.ExprDefaultContext ctx);

    void enterExprSquareParentheses(FreemarkerParser.ExprSquareParenthesesContext ctx);

    void exitExprSquareParentheses(FreemarkerParser.ExprSquareParenthesesContext ctx);

    void enterExprBoolOr(FreemarkerParser.ExprBoolOrContext ctx);

    void exitExprBoolOr(FreemarkerParser.ExprBoolOrContext ctx);

    void enterFunctionParams(FreemarkerParser.FunctionParamsContext ctx);

    void exitFunctionParams(FreemarkerParser.FunctionParamsContext ctx);

    void enterBooleanRelationalOperator(FreemarkerParser.BooleanRelationalOperatorContext ctx);

    void exitBooleanRelationalOperator(FreemarkerParser.BooleanRelationalOperatorContext ctx);

    void enterStruct(FreemarkerParser.StructContext ctx);

    void exitStruct(FreemarkerParser.StructContext ctx);

    void enterStruct_pair(FreemarkerParser.Struct_pairContext ctx);

    void exitStruct_pair(FreemarkerParser.Struct_pairContext ctx);

    void enterSingle_quote_string(FreemarkerParser.Single_quote_stringContext ctx);

    void exitSingle_quote_string(FreemarkerParser.Single_quote_stringContext ctx);

    void enterDouble_quote_string(FreemarkerParser.Double_quote_stringContext ctx);

    void exitDouble_quote_string(FreemarkerParser.Double_quote_stringContext ctx);
}
