/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.cmd;

import java.util.List;
import one.harmony.account.Account;
import one.harmony.account.Address;
import one.harmony.keys.Store;
import one.harmony.rpc.ShardingStructure;
import one.harmony.sharding.Sharding;
import one.harmony.transaction.Handler;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

public class Transfer {
    private final String from;
    private final String to;
    private final double amount;
    private final long gasPrice;
    private final int fromShard;
    private final int toShard;

    public Transfer(String from, String to) {
        this.from = from;
        this.to = to;
        this.amount = 0.0;
        this.gasPrice = 1L;
        this.fromShard = 0;
        this.toShard = 0;
    }

    public Transfer(String from, String to, double amount) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = 1L;
        this.fromShard = 0;
        this.toShard = 0;
    }

    public Transfer(String from, String to, double amount, long gasPrice) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = gasPrice;
        this.fromShard = 0;
        this.toShard = 0;
    }

    public Transfer(String from, String to, double amount, int fromShard, int toShard) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = 1L;
        this.fromShard = fromShard;
        this.toShard = toShard;
    }

    public Transfer(String from, String to, double amount, long gasPrice, int fromShard, int toShard) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = gasPrice;
        this.fromShard = fromShard;
        this.toShard = toShard;
    }

    public String execute(int chainID, String passphrase, boolean dryRun, int waitToConfirmTime) throws Exception {
        List<ShardingStructure.RPCRoutes> shards = Sharding.getShardingStructure();
        if (!Sharding.validateShardIDs(this.fromShard, this.toShard, shards.size())) {
            throw new IllegalArgumentException("Invalid shard ids passed");
        }
        String url = Sharding.getHandlerFor(shards, this.fromShard);
        String accountName = Store.getAccountNameFromAddress(this.from);
        boolean isHex = false;
        Address address = new Address(this.from, isHex);
        WalletFile walletFile = Store.extractWalletFileFromAddress(this.from);
        Credentials credentials = Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        Account account = new Account(accountName, address, credentials, walletFile);
        String payload = "";
        return new Handler(account, url).execute(chainID, this.to, payload, this.amount, this.gasPrice, this.fromShard, this.toShard, dryRun, waitToConfirmTime);
    }
}

